<?php if (extension_loaded('zlib')) {
    ob_end_clean();
    ob_start('ob_gzhandler');
}

// بسم الله الرحمن الرحیم
// نوشته شده توسط - Armin Bug ( MahdyarEn )
// هرگونه انتشار، استفاده بدون اجازه نویسنده حرام می باشد و مورد رضایت نمی باشد

error_reporting(0);
date_default_timezone_set("asia/tehran");

// require classes
require_once  'class/Base.php';
require_once  'class/Config.php';
require_once  'api/XuiApi.php';

// require JDF => jalali Date
require_once  'import/jdf.php';


//===================== V A R I A B L E =============\\
$MahdyarEn = new Base(Config::API_KEY);
@$updateType = $MahdyarEn->getUpdateType();
$update = json_decode(file_get_contents('php://input'));

// Verify Telegram Updates
if (isset($update)) {
    $telegram_ip_ranges = [['lower' => '149.154.160.0', 'upper' => '149.154.175.255'], ['lower' => '91.108.4.0', 'upper' => '91.108.7.255'],];
    $ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
    $ok = false;
    foreach ($telegram_ip_ranges as $telegram_ip_range) if (!$ok) {
        $lower_dec = (float) sprintf("%u", ip2long($telegram_ip_range['lower']));
        $upper_dec = (float) sprintf("%u", ip2long($telegram_ip_range['upper']));
        if ($ip_dec >= $lower_dec and $ip_dec <= $upper_dec) $ok = true;
        if ($_SERVER['REMOTE_ADDR'] == "185.212.202.244") {
            $ok = true;
        }
    }
    if (!$ok) die();
}

// jalali data and time
@$time = jdate('H:i:s', strtotime("-1 hours"));
@$date = jdate('l j F Y');

$dateU = date("Y/m/d");
$timeU = time();
@$from_id = $MahdyarEn->UserID();
@$chat_id = $MahdyarEn->ChatID();
@$message_id = $MahdyarEn->MessageID();
@$photo = $MahdyarEn->photo();
@$firstname = $MahdyarEn->FirstName();
@$channelTitle = $MahdyarEn->Title();
@$channelType = $MahdyarEn->Type();
@$voice_id = $MahdyarEn->voiceid();
@$file_id = $MahdyarEn->documentid();
@$caption = $MahdyarEn->Caption();
@$audio_id = $MahdyarEn->audioid();
@$sticker_id = $MahdyarEn->stickerid();
@$video_id = $MahdyarEn->videoid();
@$photo_id = $MahdyarEn->photoid();
@$gif_id  =  $MahdyarEn->gifid();
@$contact = $MahdyarEn->phone();
@$contactnum = $MahdyarEn->phonenu();
@$contactho = $MahdyarEn->phoneho();
@$data = $MahdyarEn->Callback_Data();
@$callback_id = $MahdyarEn->Callback_Data_Id();
@$getchat = $MahdyarEn->getChat(['chat_id' => $chat_id])['result'];

$config = new Config();


// database Variable
@$db = $config->db();
@$text = $MahdyarEn->protect($db, $MahdyarEn->Text());
@$user = $db->query("SELECT * FROM user WHERE id = '$from_id'")->fetch_assoc();
@$addressWeb = $db->query("SELECT * FROM settings WHERE `type` = 'address'")->fetch_assoc();

@$step = $user['step'];
@$subset = $user['invite'];
@$dayStart = jdate("Y/m/d", $user['singin']);
@$stock = $user['stock'];
@$phone = $user['phone'];
@$phone = ($phone != null) ? "تایید شده" : "تایید نشده";
@$botStatus = $db->query("SELECT * FROM settings WHERE `type` = 'bot'")->fetch_assoc();
@$phoneVerify = $db->query("SELECT * FROM settings WHERE `type` = 'phoneVerify'")->fetch_assoc();

//===================== KEYBOARDS =====================\\
if ((in_array($from_id, Config::getAdmins()))) {
    $home = json_encode(['resize_keyboard' => true, 'keyboard' => [
        [['text' => "خرید سرویس 🛍"], ['text' => "سرویس تستی [رایگان] 🎁"]],
        [['text' => "تعرفه خدمات 🗂"]],
        [['text' => "سرویس های من ⚙️"], ['text' => "حساب کاربری 🔐"]],
        [['text' => "افزایش موجودی 🛒"], ['text' => "راهنما و قوانین 📚"]],
        [['text' => "ارتباط با ما 👤"]],
        [['text' => "مدیریت 👤"]],
    ]]);
} else {
    $home = json_encode(['resize_keyboard' => true, 'keyboard' => [
        [['text' => "خرید سرویس 🛍"], ['text' => "سرویس تستی [رایگان] 🎁"]],
        [['text' => "تعرفه خدمات 🗂"]],
        [['text' => "سرویس های من ⚙️"], ['text' => "حساب کاربری 🔐"]],
        [['text' => "افزایش موجودی 🛒"], ['text' => "راهنما و قوانین 📚"]],
        [['text' => "ارتباط با ما 👤"]],
    ]]);
}

$admin = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => "📊 آمار ربات"]],
    [['text' => "⚙️ تنظیمات"], ['text' => "🌟 بخش هزینه ها"]],
    [['text' => "🔧 افزودن سرور"], ['text' => "🔧 افزودن پلن"]],
    [['text' => "🎁 افزودن پلن تستی"]],
    [['text' => "💎 وضعیت سرورها"]],
    [['text' => "💻 مدیریت سرور ها"], ['text' => "🧰 مدیریت پلن ها"]],
    [['text' => "🔖 تنظیم سرور تانل"]],
    [['text' => "🌟 افزودن همکار"], ['text' => "🌟 حذف همکار"]],
    [['text' => "👤 دریافت اطلاعات کاربر"], ['text' => "👤 پیام به کاربر"]],
    [['text' => "🔒 بخش قفل ها"], ['text' => "💳 بخش درگاه ها"]],
    [['text' => "🗳 اکسپورت از شماره مشتری ها"]],
    [['text' => "🔐 معاف جوین اجباری"], ['text' => "🔐 حذف معاف ها"]],
    [['text' => "🎁 افزودن کد تخفیف"], ['text' => "🎁 وضعیت کدهای تخفیف"]],
    [['text' => "📬 فوروارد همگانی"], ['text' => "📨 ارسال همگانی"]],
    [['text' => "💰 افزایش موجودی"], ['text' => "💰 کاهش موجودی"]],
    [['text' => "📍 افزودن دکمه"], ['text' => "📍 حذف دکمه"]],
    [['text' => "✅ آنبلاک کاربر"], ['text' => "❌ بلاک کردن کاربر"]],
    [['text' => "🔖  افزودن ادمین"], ['text' => "❌ حذف ادمین"]],
    [['text' => "🔙 بازگشت"]],
]]);

$pay_false  = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => '⚠️ تایید و ارسال شماره', 'request_contact' => true]],
    [['text' => "🔙 بازگشت"]],
]]);

$back = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => "🔙 بازگشت"]],
]]);
$backInline =  json_encode(['inline_keyboard' => [
    [['text' => "🔙 بازگشت", 'callback_data' => 'back']],
]]);
$backAdmin = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => "بازگشت 🔙"]],
]]);

$pay_true = json_encode(['inline_keyboard' => [
    [['text' => "💳 کارت به کارت", 'callback_data' => 'payOffline']],
    [['text' => "💎 پرداخت با درگاه ( IRR )", 'callback_data' => 'payShaparak'], ['text' => "💰 پرداخت با ارز", 'callback_data' => 'payCurrency']],
    [['text' => "👥 زیرمجموعه گیری", 'callback_data' => 'subset']],
]]);

//===================== KEYBOARDS =====================\\

//===================== FUNCTIONS =====================\\
function getExempt()
{
    global $db;
    $result = [];
    $query = $db->query("SELECT * FROM settings WHERE `type` = 'exempt'")->fetch_assoc()["type_id"];
    if ($query != null) {
        $explode = explode('|', $query);
        for ($i = 0; $i < substr_count("{$query}", '|'); $i++) {
            array_push($result, $explode[$i]);
        }
    }
    return $result;
}
function checkJoin($from_id)
{
    global $db;
    global $MahdyarEn;
    $status = true;
    $channel = $db->query("SELECT * FROM settings WHERE `type` = 'channel'");
    while ($row = $channel->fetch_assoc()) {
        $chId = $row['type_id'];
        $nameCh = $row['columnOne'];
        $linkCh = $row['columnTwo'];
        $join = $MahdyarEn->getChatMember(['chat_id' => $chId, 'user_id' => $from_id])['result']['status'];

        if ($join != 'member' and $join != 'creator' and $join != 'administrator') {
            $key[] =  [['text' => $nameCh, 'url' => $linkCh]];
            $status = false;
        }
    }
    $key[] = [['text' => "تایید عضویت ✅", 'callback_data' => 'imjoined']];
    if ((in_array($from_id, getExempt()))) $status = true;
    return [$status, $key];
}
$chackJoin = checkJoin($from_id);

function checkPage($perRow, $all, $max = 80)
{
    return ceil((($all + 1) * $perRow) / $max);
}

function convertFileSize($size, $from, $to)
{
    $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
    $from_index = array_search($from, $units);
    $to_index = array_search($to, $units);

    if ($from_index === false || $to_index === false)
        return "Invalid units";


    if (!is_numeric($size) || $size < 0)
        return "Invalid size";


    return $size * pow(1024, $from_index - $to_index);
}

function getSize($size, $round = 2)
{
    if ($size == 0) return "0 بایت";
    return round($size / pow(1024, ($i = floor(log($size, 1024)))), $round) . ' ' . ['بایت', 'کیلوبایت', 'مگابایت', 'گیگابایت', 'ترابایت', 'پتابایت'][$i];
}

function ConnectXui($link, $username, $password)
{
    $isHttps = substr($link, 0, 7) === "http://" ? false : true;
    $url = explode(':', str_replace(array("http://", "https://"), "", $link));
    return new XuiApi($isHttps, $url[0], $url[1], $username, $password);
}
//===================== FUNCTIONS =====================\\
// Add Lock channel
if (strpos($text, '/lock_') !== false && ($getchat['type'] == "supergroup" || $getchat['type'] == "channel" || $getchat['type'] == "group")) {
    $usres = $db->query("SELECT * FROM user");
    while ($row = $usres->fetch_assoc()) {
        if ($text ==  $row['step']) {
            $inviteLink = $MahdyarEn->createChatInviteLink(['chat_id' => $chat_id])['result']['invite_link'];
            if ($inviteLink) {
                $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
                $db->query("UPDATE user SET step = 'none+' WHERE id = '{$row['id']}'");
                $usernameCh = $username ? '@' . $username : 'ندارد';
                $db->query("INSERT INTO `settings` (`type`, `type_id`, `columnOne`, `columnTwo`) VALUES ('channel', '$chat_id', '$channelTitle', '$inviteLink')");
                $MahdyarEn->Sendmessage(['chat_id' => $row['id'], 'text' => "✅ قفل با موفقیت اضافه شد. \n\n👈 نوع قفل : <code>$channelType</code>\n✏️ نام : <code>$channelTitle</code>\n👤 نام کاربری : <code>$usernameCh</code>\n🔗 لینک : $inviteLink\n👈 ایدی عددی قفل : <code>$chat_id</code>\n‌", 'disable_web_page_preview' => true, 'parse_mode' => 'html', 'reply_markup' => $admin]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $row['id'], 'text' => "⭕️ ربات دسترسی ساخت لینک را ندارد. لطفا دسترسی لازم را بدهید.", 'disable_web_page_preview' => true, 'parse_mode' => 'html']);
            }
        }
    }
}
if ($getchat['type'] != "private" && !in_array($from_id, Config::getAdmins())) die;
if ($user['ban'] == 1) die;



// Checking join states
if ($data == "imjoined") {
    if (($chackJoin[0])) {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "عضویت شما تایید شد ✅", 'show_alert' => false]);
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ عضویت شما تایید شد!", 'reply_markup' => $home]);
    } else {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "⭕️ هنوز داخل تمامی کانال ها عضو نشدید.\n", 'show_alert' => false]);
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کاربر عزیز برای استفاده از ربات باید عضو کانال های تعیین شده بشوید 👇🏻", 'disable_web_page_preview' => true, 'reply_markup' => json_encode(['inline_keyboard' => $chackJoin[1]])]);
    }
    exit();
}

// SUBSET
if (preg_match('/^(\/start) (.*)/', $text, $match)) {
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "سلام به ربات " . Config::NAME . " خوش آمدید 🌹\n با این ربات میتوانید بصورت خودکار کانفیگ تهیه کنید 🌟\n‌", 'reply_markup' => $home, 'parse_mode' => "html"]);
    if ($user['id'] != true) {
        $db->query("INSERT INTO user(id,singin,addStock,inviter) VALUES('$from_id','$timeU','no','$match[2]')");
        $usera =  $db->query("SELECT * FROM user WHERE id = $match[2]")->fetch_assoc();
        if ($match[2] != null && $usera['id'] != false) {
            $MahdyarEn->Sendmessage(['chat_id' => $match[2], 'text' => "✅ یک نفر با لینک شما به ربات پیوست\n\nبه محض اینکه حساب خود را تایید کنند (عضویت در کانال و فعالیت در ربات) موجودی شما به مقدار {$config->subset} تومان شارژ خواهد شد.\n‌", 'reply_markup' => $home]);
        }
    }
    exit();
}


// manual start
elseif (preg_match('/^\/(start)$/i', $text)) {
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "سلام به ربات " . Config::NAME . " خوش آمدید 🌹\n با این ربات میتوانید بصورت خودکار کانفیگ تهیه کنید 🌟\n‌", 'reply_markup' => $home, 'parse_mode' => "html"]);
    if (!$user['id']) {
        $joinStock = $config->joinStock;
        $db->query("INSERT INTO user(id,singin,addStock,stock) VALUES('$from_id','$timeU','yes','$joinStock')");
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "✨ کاربر [$chat_id](tg://user?id=$chat_id) توسط کاربر [0000000](tg://user?id=0000000) به ربات پیوست", 'parse_mode' => 'MarkDown']);
    }
    exit();
} elseif (!$chackJoin[0] and $getchat['type'] == 'private') {
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کاربر عزیز برای استفاده از ربات باید عضو کانال های تعیین شده بشوید 👇🏻", 'disable_web_page_preview' => true, 'reply_markup' => json_encode(['inline_keyboard' => $chackJoin[1]])]);
    exit();
} elseif ($updateType && $user['id'] != true) {
    $joinStock = $config->joinStock;
    $db->query("INSERT INTO user(id,singin,addStock,stock) VALUES('$from_id','$timeU','yes','$joinStock')");
    $usera =  $db->query("SELECT * FROM user WHERE id = $match[2]")->fetch_assoc();
}


// add stock to subset
if ($user['addStock'] == 'no') {
    $db->query("UPDATE user SET stock = stock+{$config->subset}, invite = invite+1  WHERE id = '{$user['inviter']}'");
    $db->query("UPDATE user SET step = 'none', addStock = 'yes'  WHERE id = '$from_id'");
    $MahdyarEn->Sendmessage(['chat_id' => $user['inviter'], 'text' => "✨ تبریک یک کاربر با لینک شما عضو ربات شد و مقدار {$config->subset} سکه به حساب شما افزوده شد.\n\n👈 در صورت خرید توسط زیرمجموعه شما، مقدار {$config->commission}% خرید به حساب شما افزوده خواهد شد.\n‌‌", 'reply_markup' => $home]);
    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "✨ کاربر [$chat_id](tg://user?id=$chat_id) توسط کاربر [{$user['inviter']}](tg://user?id={$user['inviter']}) به ربات پیوست", 'parse_mode' => 'MarkDown']);
}

if ($botStatus['type_id'] == 'off' && !in_array($from_id, Config::getAdmins())) {
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⭕️ درحال حاضر ربات خاموش می باشد", 'reply_markup' => $home]);
    exit();
}


// ================= handle text ================== \\
switch ($text) {
    case "🔙 بازگشت":
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 به منوی اصلی بازگشتید لطفا یکی از دکمه های زیر را انتخاب کنید :", 'reply_markup' => $home]);
        exit();
        break;

    case "بازگشت 🔙":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 ادمین گرامی به پنل مدیریت خوش آمدید، برای انجام عملیات یکی از دکمه های زیر را انتخاب کنید:\n‌", 'reply_markup' => $admin]);
        }
        exit();
        break;

    case "حساب کاربری 🔐":
        $stock = number_format($stock);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "اطلاعات حساب کاربری شما در ربات " . Config::NAME . " :\n\n📄 شناسه شما: $chat_id\n👥 زیرمجموعه: $subset نفر\n📌 وضعیت تایید شماره: $phone\n💸 موجودی شما: $stock تومان\n💎 تعداد سرویس ها: " . $db->query("SELECT id FROM config WHERE user = '$chat_id'")->num_rows . "\n\n🕒 این گزارش وضعیت در تاریخ $date ، ساعت $time میباشد.\n‌"]);
        break;

    case "خرید سرویس 🛍":
    case "buyService":
        $userConfigs = $db->query("SELECT * FROM servers WHERE stats = '✅'")->fetch_assoc();
        if (isset($data)) {
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        }
        if ($userConfigs) {
            $allServers = $db->query("SELECT * FROM servers WHERE stats = '✅'");
            while ($row = $allServers->fetch_assoc()) {
                $key[] = [['text' => $row['name'], 'callback_data' => "buy_{$row['id']}"]];
            }
            $key[] = [['text' => "🔙 بازگشت", 'callback_data' => 'back']];
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لطفا برای خرید یکی از سرور های زیر را انتخاب کنید:",  'reply_markup' => json_encode(['inline_keyboard' => $key])]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📍 درحال حاضر سرویسی جهت فروش فعال نمی باشد.", 'reply_markup' => $home]);
        }
        break;


    case "تعرفه خدمات 🗂":
    case "tariff":
        $userConfigs = $db->query("SELECT * FROM servers WHERE stats = '✅'")->fetch_assoc();
        if (isset($data)) {
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        }
        if ($userConfigs) {
            $allServers = $db->query("SELECT * FROM servers WHERE stats = '✅'");
            while ($row = $allServers->fetch_assoc()) {
                $key[] = [['text' => $row['name'], 'callback_data' => "seeTariff_{$row['id']}"]];
            }
            $key[] = [['text' => "🔙 بازگشت", 'callback_data' => 'back']];
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا برای دیدن لیست قیمت ها یکی از سرور های زیر را انتخاب کنید.",  'reply_markup' => json_encode(['inline_keyboard' => $key])]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📍 درحال حاضر سرویسی جهت فروش فعال نمی باشد.", 'reply_markup' => $home]);
        }
        break;


    case "سرویس تستی [رایگان] 🎁":
        if ($user['phone'] != '' || in_array($from_id, Config::getAdmins())) {
            if (!$user['test'] || in_array($from_id, Config::getAdmins())) {
                $now =  $db->query("SELECT * FROM plan WHERE `name` = 'testService'")->fetch_assoc();
                if ($now['name']) {
                    try {
                        $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$now['serverid']}'")->fetch_assoc();
                        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال ساخت کانکشن شما لطفا صبور باشید..."]);
                        // config information
                        $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
                        $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
                        $expireD = date('Y/m/d H:i', strtotime("+{$now['date']} days"));
                        $expire = strtotime($expireD) * 1000;
                        $startD = date('Y/m/d H:i');
                        //    connect to xui panel api
                        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
                        $randId = rand(10000, 90000);
                        $random = $randId . "-test-" . $selectServer['remark'] . "@gmail.com";
                        $remark =  $randId . "-test-" . $selectServer['remark'];
                        $traffic = round(($now['traffic'] / 1000) * 1024 * 1024 * 1024);
                        if ($now['rowid'] != 0) {
                            $add = $xui->addClientToInbound($now['rowid'], $traffic, $now['protocol'], $remark, $random, $expire, '', $now['iplimit'], $selectServer['host']);
                        } else {
                            $add = $xui->addInbound($traffic, 0, 0, true, $remark, null, $now['protocol'], $expire, $now['iplimit'], $now['network'], $now['security'], $now['domain'], $selectServer['host']);
                        }
                        if ($add["success"] == true) {
                            // GET qrcode of congif
                            $code = $MahdyarEn->random();
                            $link = $MahdyarEn->getConfigLink($add["link"], $now['protocol'], $url[0], $now['domain'], $selectServer['host'], $selectServer['tunnel']);
                            $qrCode = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=" . urlencode($link);
                            $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $qrCode, 'caption' => "✅ کانفیک از سرویس تست برای شما با موفقیت ساخته شد.\n\n🔗 <code>$link</code>\n\n🔖 کد سرویس: <code>$remark</code>\n🌟 از این پس با استفاده از دستور زیر میتوانید سریع تر سرویس خود را مدیریت کنید:\n/service_$code\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "مدیریت سرویس", 'callback_data' => "manageService_$code"]]]])]);
                            $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "✅ کانکشن تستی برای کاربر {$selectServer['name']} برای کاربر <a href='tg://user?id=$from_id'>$from_id</a> ساخته شد. \n\n🔖 کد سرویس: <code>$remark</code>\n\nلینک کانکشن: <code>$link</code>\n#اکانت_تست", 'parse_mode' => 'html']);
                            if ($now['rowid'] != 0) {
                                $db->multi_query("INSERT INTO `config` (`user`, `planid`, `expire`, `link`,`inboundid`,`clientid`,`code`,`remark`,`start`) VALUES ('$chat_id', {$now['id']}, '$expireD', '{$add["link"]}', '{$now['rowid']}','$random','$code','$remark','$startD');UPDATE user SET test = 1 WHERE id = '$from_id'");
                            } else {
                                $db->multi_query("INSERT INTO `config` (`user`, `planid`, `expire`, `link`,`inboundid`,`code`,`remark`,`start`) VALUES ('$chat_id', '{$now['id']}', '$expireD', '{$add["link"]}', '{$add["id"]}','$code','$remark','$startD');UPDATE user SET test = 1 WHERE id = '$from_id'");
                            }
                        } else {
                            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر مشکلی پیش آمده، لطفا بعدا دوباره امتحان کنید.", 'reply_markup' => $home]);
                        }
                    } catch (Exception $e) {
                        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
                    }
                } else {
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر امکان دریافت سرور تست وجود ندارد‌", 'reply_markup' => $home]);
                }
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما قبلا سرویس تست خود را تحویل گرفتید. از قسمت «سرویس های من ⚙️» میتوانید مشخصات سرویس خود را مشاهده کنید", 'reply_markup' => $home]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🔐 کاربر گرامی به منظور افزایش امنیت در پرداخت ها، و همچنین اطلاع رسانی ربات،\n\n👇  لطفا شماره خود را از طریق دکمه زیر ارسال کنید. (شماره ارسالی شما نزد ما محفوظ خواهد ماند.)\n‌‌", 'reply_markup' => $pay_false]);
            $db->query("UPDATE user SET step = 'phone+' WHERE id = '$from_id' ");
        }

        break;

    case "سرویس های من ⚙️":
        $userConfigs = $db->query("SELECT * FROM config WHERE user = '$chat_id'")->fetch_assoc();
        if ($userConfigs) {
            $userConfig = $db->query("SELECT * FROM config WHERE user = '$chat_id' LIMIT 10 OFFSET 0");
            while ($row = $userConfig->fetch_assoc()) {
                @$selectServer = $db->query("SELECT servers.name FROM servers JOIN plan ON plan.serverid = servers.id WHERE plan.id = '{$row['planid']}' ")->fetch_assoc();
                $button[] = [['text' => $selectServer["name"] . " - " . $row['code'], 'callback_data' => "manageService_{$row['code']}"]];
            }
            $configCount = $db->query("SELECT id FROM config WHERE user = '$chat_id'")->num_rows;
            if ((checkPage(1, $configCount - 1, 10) != 1)) {
                $button[] = [['text' => "👉", 'callback_data' => "servicePage_2"]];
            }

            $button[] = [['text' => "🔙 بازگشت", 'callback_data' => 'back']];
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 جهت مدیریت، یکی از سرویس های خود را  انتخاب کنید", 'reply_markup' => json_encode(['inline_keyboard' => $button]), 'parse_mode' => 'html']);
            $db->query("UPDATE user SET step = 'seeServices' WHERE id = '$from_id' ");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لیست سفارش ها شما خالی می باشد. لطفا یک پلن جدید خریداری کنید.", 'reply_markup' => $home]);
        }
        break;


    case "افزایش موجودی 🛒":
        if ($user['phone'] == "" && $phoneVerify == "on") {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🔐 کاربر گرامی به منظور افزایش امنیت در پرداخت ها، و همچنین اطلاع رسانی ربات،\n\n👇  لطفا شماره خود را از طریق دکمه زیر ارسال کنید. (شماره ارسالی شما نزد ما محفوظ خواهد ماند.)\n‌‌", 'reply_markup' => $pay_false]);
            $db->query("UPDATE user SET step = 'phone+' WHERE id = '$from_id' ");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⚖️ پرداخت شما به منزله تایید قوانین می باشد.\n\n🛒 پس از پرداخت با یکی از روش های زیر، حساب شما بصورت خودکار شارژ می شود.\n\n👇 جهت افزایش موجودی، یکی از روش های زیر را انتخاب کنید.", 'reply_markup' => $pay_true]);
            $db->query("UPDATE user SET step = 'bye+' WHERE id = '$from_id' ");
        }
        break;

    case "ارتباط با ما 👤":
        $db->query("UPDATE user SET step = 'suport+' WHERE id = '$from_id'");
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👨‍💻 همکاران ما در خدمت شما هستند!\n\n🗣 در صورتیکه پاسخ سوال خود را در بخش سوالات متداول دریافت نکردید ؛ پیام خود را در قالب یک پیام ارسال کنید و از سلام و احوال پرسی خودداری کنید.\n\n⏳ زمان پاسخگویی به سوال شما با توجه به درخواست ها از 1 دقیقه تا 24 ساعت ممکن است زمان بر باشد ؛ پس لطفا تا زمان دریافت پاسخ خود صبور باشید!\n\n📬 پیام شما میتواند شامل عکس، ویدئو، گیف، ویس، ویدئو مسیج و... باشد.‌‌", 'reply_markup' => $back]);
        break;


    case "مدیریت 👤":
    case "/panel":
    case "پنل":
    case "مدیریت":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 ادمین گرامی به پنل مدیریت خوش آمدید، برای انجام عملیات یکی از دکمه های زیر را انتخاب کنید:\n‌", 'reply_markup' => $admin]);
        }
        break;

    case "📊 آمار ربات":
        if ((in_array($from_id, Config::getAdmins()))) {

            $dateD = strtotime(date("Y/m/d"));
            $ydate =  strtotime(date("Y/m/d", strtotime("-1 days")));
            $lWeeks = strtotime(date('Y/m/d', strtotime("-7 days")));
            $lastMonth = strtotime(date('Y/m/d', strtotime("-30 days")));
            $timeOnline = $timeU - 600;
            $timeLastHour = $timeU - 3600;

            $userCount = $db->query("SELECT id from user")->num_rows;
            $configCount = $db->query("SELECT id from config")->num_rows;
            $serverCount = $db->query("SELECT id from servers")->num_rows;
            $planCount = $db->query("SELECT id from plan")->num_rows;

            $today = $db->query("SELECT id from user WHERE singin >= '$dateD'")->num_rows;
            $yesday = $db->query("SELECT id from user WHERE singin >= '$ydate' AND singin < '$dateD'")->num_rows;
            $lWeek = $db->query("SELECT id from user WHERE singin >= '$lWeeks' AND singin < '$dateD' AND  singin < '$ydate'")->num_rows;
            $lMount = $db->query("SELECT id from user WHERE singin  >=  '$lastMonth' AND singin < '$lWeeks' AND singin < '$dateD' AND singin < '$ydate'")->num_rows;
            $payed = $db->query("SELECT id from pay WHERE stats = 1")->num_rows;
            $online = $db->query("SELECT id from user WHERE `time` > '$timeOnline'")->num_rows;
            $lastHour = $db->query("SELECT id from user WHERE `time` > '$timeLastHour' AND `time` < '$timeOnline'")->num_rows;

            $allSell = number_format(intval($db->query("SELECT SUM(amount) from pay WHERE `stats` = '1'")->fetch_assoc()['SUM(amount)']));
            $sellToday = number_format(intval($db->query("SELECT SUM(amount) from pay WHERE `stats` = '1' AND `time` >= '$ydate'")->fetch_assoc()['SUM(amount)']));
            $sellYesday = number_format(intval($db->query("SELECT SUM(amount) from pay WHERE `stats` = '1' AND `time` >= '$ydate' AND `time` < '$dateD'")->fetch_assoc()['SUM(amount)']));
            $sellLWeek = number_format(intval($db->query("SELECT SUM(amount) from pay WHERE `stats` = '1' AND `time` >= '$lWeeks' AND `time` < '$dateD' AND  `time` < '$ydate'")->fetch_assoc()['SUM(amount)']));
            $sellLMount = number_format(intval($db->query("SELECT SUM(amount) from pay WHERE `stats` = '1' AND `time`  >=  '$lastMonth' AND `time` < '$lWeeks' AND `time` < '$dateD' AND `time` < '$ydate'")->fetch_assoc()['SUM(amount)']));

            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📊 آمار ربات شما 🕒 در تاریخ $date ، ساعت $time ، به شرح زیر می باشد\n\n👥 تعداد کل کاربران: <code>$userCount</code>\n\n🗓 تعداد عضویت امروز: <code>$today</code>\n🗓 تعداد عضویت دیروز: <code>$yesday</code>\n🕰 تعداد عضویت هفته پیش: <code>$lWeek</code>\n📅 تعداد عضویت ماه پیش: <code>$lMount</code>\n\n✅ تعداد کابران آنلاین: <code>$online</code>\n⏱ تعداد کاربران ساعت گذشته: <code>$lastHour</code>\n\n🗂 تعداد فاکتور های پرداخت شده: <code>$payed</code>\n\n💎 تعداد سرورها: <code>$serverCount</code>\n📑 تعداد پلن ها: <code>$planCount</code>\n📍 تعدا کانفیگ ها: <code>$configCount</code>\n\n💰 فروش کل: $allSell\n💶 فروش امروز: $sellToday تومان\n💸 فروش دیروز: $sellYesday تومان\n💰 فروش هفته پیش: $sellLWeek تومان\n💳 فروش ماه پیش: $sellLMount تومان\n‌", 'reply_markup' => $admin, 'parse_mode' => 'html']);
        }
        break;

    case "🔧 افزودن سرور":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📁 برای افزودن سرور لطفا هر یک از موارد زیر را به ترتیب و در یک خط جداگانه وارد کنید: \n\n👈 مقدار اول (نام سرور): این نام در بخش خرید نمایش داده میشود \n\n👈 مقدار دوم (حداکثر حجم ساخت کانکشن): بصورت عدد لاتین وارد شود. برای تعیین حداکثر حجم ظرفیت ساخت کانکشن می باشد. \n\n👈 مقدار سوم (نام کانکشن های ساخته شده): بصورت اینگلیسی و بدون فاصله \n\nمقدار چهارم (اختیاری - host): درصورتی که میخواهید در کانکشن های ساخته شده از این سرور مقدار host تنظیم شود، یک دامنه بدون http | https وارد کنید در غیراین صورت خالی بگذارید.\n\n🏷 مثال:\n\n<code>German - آلمان 🇩🇪\n3500\nGermanServer\ndomain.com</code>", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
            $db->query("UPDATE user SET step = 'addServer' WHERE id = '$from_id' ");
        }
        break;

    case "💻 مدیریت سرور ها":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allservers = $db->query("SELECT * FROM servers")->fetch_assoc();
            if ($allservers) {
                @$selectServers = $db->query("SELECT * FROM servers");
                $button[] = [['text' => "وضعیت نمایش", 'callback_data' => 'n'], ['text' => "حذف", 'callback_data' => 'n'], ['text' => "ویرایش", 'callback_data' => 'n'], ['text' => "حجم 🔢", 'callback_data' => 'n'], ['text' => "نام ℹ️", 'callback_data' => 'n']];

                while ($row = $selectServers->fetch_assoc()) {
                    $button[] = [['text' => $row['stats'], 'callback_data' => "toggleStats_{$row['id']}"], ['text' => "❌", 'callback_data' => "removeServer_{$row['id']}"], ['text' => "✏️", 'callback_data' => "editServer_{$row['id']}"], ['text' => $row['max'], 'callback_data' => 'n'], ['text' => $row['name'], 'callback_data' => 'n']];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لیست سرور ها به شرح زیر می باشد\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ سروری اضافه نکردید", 'reply_markup' => $admin]);
            }
        }
        break;

    case "🔧 افزودن پلن":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allservers = $db->query("SELECT * FROM servers")->fetch_assoc();
            if ($allservers) {
                $servers = $db->query("SELECT * FROM servers");
                while ($row = $servers->fetch_assoc()) {
                    $button[] = [['text' => $row['id'] . " - " . $row['name'], 'callback_data' => "setSrvPlan_{$row['id']}"]];
                }
                $button[] = [['text' => "بازگشت 🔙", 'callback_data' => "backAdmin"]];
                $key =  json_encode(['inline_keyboard' => $button]);

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لطفا سروری را که قصد اضافه کردن پلن به آن هستید را انتخاب کنید", 'reply_markup' => $key, 'parse_mode' => 'html']);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ سروری اضافه نکردید", 'reply_markup' => $admin]);
            }
        }
        break;


    case "🎁 افزودن پلن تستی":
        @$selectPlan = $db->query("SELECT * FROM plan WHERE `name` = 'testService'")->fetch_assoc();
        if (!$selectPlan['id']) {
            if ((in_array($from_id, Config::getAdmins()))) {
                $servers = $db->query("SELECT * FROM servers");
                while ($row = $servers->fetch_assoc()) {
                    $button[] = [['text' => $row['id'] . " - " . $row['name'], 'callback_data' => "setTestPlan_{$row['id']}"]];
                }
                $button[] = [['text' => "بازگشت 🔙", 'callback_data' => "backAdmin"]];
                $key =  json_encode(['inline_keyboard' => $button]);

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لطفا سروری را که قصد اضافه کردن پلن تست به آن هستید را انتخاب کنید", 'reply_markup' => $key, 'parse_mode' => 'html']);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕ پلن تست قبلا ثبت شده است، لطفا از طریق مدیریت پلن اقدام به ویرایش یا حذف آن کنید", 'reply_markup' => $key, 'parse_mode' => 'html']);
        }

        break;

    case "🧰 مدیریت پلن ها":
    case "managePlans":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allPlans = $db->query("SELECT * FROM plan")->fetch_assoc();
            if (isset($data) && $data == "managePlans") $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

            if ($allPlans) {
                @$selectPlan = $db->query("SELECT * FROM plan WHERE changed = 0 LIMIT 19 OFFSET 0");
                $button[] = [['text' => "حذف", 'callback_data' => 'n'], ['text' => "ویرایش", 'callback_data' => 'n'], ['text' => "🌐 سرور", 'callback_data' => 'n'], ['text' => "نام ℹ️", 'callback_data' => 'n']];
                while ($row = $selectPlan->fetch_assoc()) {
                    $selectServer = $db->query("SELECT servers.name FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$row['id']}'")->fetch_assoc();
                    $button[] = [['text' => "❌", 'callback_data' => "removePlan_{$row['id']}"], ['text' => "✏️", 'callback_data' => "editPlan_{$row['id']}"], ['text' => $selectServer['name'], 'callback_data' => 'n'], ['text' => $row['name'], 'callback_data' => 'n']];
                }
                $planCount = $db->query("SELECT id FROM plan WHERE changed = 0")->num_rows;
                if ((checkPage(4, $planCount) != 1)) {
                    $button[] = [['text' => "👉", 'callback_data' => "planPage_2"]];
                }
                $button[] = [['text' => "انصراف", 'callback_data' => "backAdmin"]];

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لیست پلن ها به شرح زیر می باشد\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ پلنی اضافه نکردید", 'reply_markup' => $admin]);
            }
        }
        break;

    case "🎁 افزودن کد تخفیف":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'addDiscount' WHERE id = '$from_id'");
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎁 برای افزودن کد تخفیف هرکدام از موارد زیر را به ترتیب و در یک خط جدید وارد کنید:\n\nمقدار اول: کد تخفیف مورد نظر\nمقدار دوم: درصد تخفیف\nمقدار سوم: حداکثر تعداد استفاده از کد\n\n\n\n🌟 نمونه:\n\n<code>10DISCOUNT\n30\n5</code> ", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        }
        break;


    case "🎁 وضعیت کدهای تخفیف":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allDiscount = $db->query("SELECT * FROM settings WHERE `type` = 'discount'")->fetch_assoc();
            if ($allDiscount) {
                @$selectDiscount = $db->query("SELECT * FROM settings WHERE `type` = 'discount'");
                $button[] = [['text' => "حذف", 'callback_data' => 'n'], ['text' => "تعداد استفاده", 'callback_data' => 'n'], ['text' => "حداکثر استفاده", 'callback_data' => 'n'],  ['text' => "درصد تخفیف", 'callback_data' => 'n'], ['text' => "کد تخفیف 🎁", 'callback_data' => 'n']];
                while ($row = $selectDiscount->fetch_assoc()) {
                    $_ =  explode('|', $row['columnTwo']);
                    $button[] = [['text' => '❌', 'callback_data' => "removeDis~{$row['type_id']}"], ['text' => $_[1], 'callback_data' => "n"], ['text' => $_[0], 'callback_data' => "n"], ['text' => $row['columnOne'], 'callback_data' => 'n'], ['text' => $row['type_id'], 'callback_data' => 'n']];
                }
                $button[] = [['text' => "انصراف", 'callback_data' => "backAdmin"]];

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لیست کدهای تخفیف ایجاد شده به شرح زیر می باشد\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ کد تخفیفی ایجاد نکردید", 'reply_markup' => $admin]);
            }
        }
        break;

    case "📨 ارسال همگانی":
        if ((in_array($from_id, Config::getAdmins()))) {
            $send = $db->query("SELECT * FROM `sendall` LIMIT 1")->fetch_assoc();
            if ($send['step'] == '') {
                $db->query("UPDATE user SET step = 'send+' WHERE id = '$from_id'");
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👈 پیام خود را در قالب (متن، عکس، استیکر، فایل صوتی، ویدیو و... ) ارسال کنید.", 'reply_markup' => $backAdmin]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💢 خطا شما یک پیام در صف ارسال دارید، برای دادن پیام بعدی باید ابتدا پیام قبلی را حذف کنید.\n\n❗️ برای کنسل کردن ارسال پیام دستور\n\n/cancel_sending", 'reply_markup' => $panel, 'parse_mode' => 'html']);
            }
        }
        break;

    case "📬 فوروارد همگانی":
        if ((in_array($from_id, Config::getAdmins()))) {
            $send = $db->query("SELECT * FROM `sendall` LIMIT 1")->fetch_assoc();
            if ($send['step'] == '') {

                $db->query("UPDATE user SET step = 'forward+' WHERE id = '$from_id'");
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👌 پیام خود را ارسال کنید", 'reply_markup' => $backAdmin]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💢 خطا شما یک پیام در صف ارسال دارید، برای دادن پیام بعدی باید ابتدا پیام قبلی را حذف کنید.\n\n❗️ برای کنسل کردن ارسال پیام دستور\n\n/cancel_sending", 'reply_markup' => $panel, 'parse_mode' => 'html']);
            }
        }
        break;

    case "💰 افزایش موجودی":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'increaseStock' WHERE id = '$from_id'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👤 شناسه کاربر مورد نظر را وارد کنید", 'parse_mode' => 'MarkDown', 'reply_markup' =>  $backAdmin]);
        }
        break;

    case "💰 کاهش موجودی":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'decrease' WHERE id = '$from_id'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👤 شناسه کاربر مورد نظر را وارد کنید", 'parse_mode' => 'MarkDown', 'reply_markup' =>  $backAdmin]);
        }
        break;


    case "🔐 معاف جوین اجباری":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'addExempt' WHERE id = '$from_id'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "📁 آیدی عددی شخص مورد نظر را وارد کنید تا از جوین اجباری ربات معاف شود.", 'parse_mode' => 'MarkDown', 'reply_markup' => $backAdmin]);
        }
        break;

    case "🔐 حذف معاف ها":
        if ((in_array($from_id, Config::getAdmins()))) {
            $key[] =  [['text' => "❕ حذف شخص", 'callback_data' => "n"], ['text' => "👤 شناسه کاربر", 'callback_data' => "n"]];
            $exempts = $db->query("SELECT * FROM `settings` WHERE `type`= 'exempt'")->fetch_assoc();
            if (!$exempts['type_id']) {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' =>  "❌ کاربری از جوین اجباری معاف نشده است", 'parse_mode' => 'MarkDown', 'reply_markup' => $admin]);
            } else {
                $db->query("UPDATE user SET step = 'removeExemp' WHERE id = '$from_id'");
                $list = explode("|", $exempts['type_id']);
                array_pop($list);
                foreach ($list as $exempt) {

                    $key[] = [['text' => "حذف", 'callback_data' => $exempt], ['text' => $exempt, 'callback_data' => "z"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👇 لطفا یکی از دکمه های زیر را انتخاب کنید", 'parse_mode' => 'MarkDown', 'reply_markup' => json_encode(['inline_keyboard' => $key])]);
            }
        }
        break;

    case "🔖  افزودن ادمین":
        if ((in_array($from_id, Config::getAdmins()))) {
            $db->query("UPDATE user SET step = 'addAdmin+' WHERE id = '$from_id'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "📁 آیدی عددی شخص مورد نظر را وارد کنید تا ادمین ربات شود.", 'parse_mode' => 'MarkDown', 'reply_markup' => $backAdmin]);
        }
        break;

    case "❌ حذف ادمین":
        if ((in_array($from_id, Config::getAdmins()))) {
            $key[] =  [['text' => "❕ حذف شخص", 'callback_data' => "n"], ['text' => "👤 شناسه کاربر", 'callback_data' => "n"]];
            if (empty(Config::getAdmins(true))) {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' =>  "❌ ادمینی اضافه نشده است", 'parse_mode' => 'MarkDown', 'reply_markup' => $admin]);
            } else {
                $db->query("UPDATE user SET step = 'removeAdmin+' WHERE id = '$from_id'");
                foreach (Config::getAdmins(true) as $admin) {

                    $key[] = [['text' => "حذف", 'callback_data' => $admin], ['text' => $admin, 'callback_data' => "z"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👇 لطفا یکی از دکمه های زیر را انتخاب کنید", 'parse_mode' => 'MarkDown', 'reply_markup' => json_encode(['inline_keyboard' => $key])]);
            }
        }
        break;

    case "🌟 حذف همکار":
        if ((in_array($from_id, Config::getAdmins()))) {
            $key[] =  [['text' => "❕ حذف شخص", 'callback_data' => "n"], ['text' => "👤 شناسه کاربر", 'callback_data' => "n"]];
            $cooperation = $db->query("SELECT * FROM user WHERE cooperation = '1'");
            if ($cooperation->num_rows == 0) {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' =>  "❌ همکاری اضافه نشده است", 'parse_mode' => 'MarkDown', 'reply_markup' => $admin]);
            } else {
                $db->query("UPDATE user SET step = 'removeCooperation' WHERE id = '$from_id'");
                while ($row = $cooperation->fetch_assoc()) {
                    $key[] = [['text' => "حذف", 'callback_data' => $row['id']], ['text' => $row['id'], 'callback_data' => "z"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👇 لطفا یکی از دکمه های زیر را انتخاب کنید", 'parse_mode' => 'MarkDown', 'reply_markup' => json_encode(['inline_keyboard' => $key])]);
            }
        }
        break;

    case "🔒 بخش قفل ها":
        if ((in_array($from_id, Config::getAdmins()))) {
            if (empty(Config::getChannels())) {
                $random = $MahdyarEn->random();
                $db->query("UPDATE user SET step = '/lock_$random' WHERE id = '$from_id'");
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "برای افزودن قفل(کانال یا گروه) طبق مراحل زیر پیش بروید👇\n\n1️⃣ ربات را در (کانال یا گروه) مورد نظر ادمین کنید.\n2️⃣ دستور زیر را کپی و در (کانال یا گروه) ارسال کنید.\n<code>/lock_$random</code>\n☑️ اگر پیام شما حذف شد به معنای اضافه شدن کانال شما است.", 'parse_mode' => 'html', 'reply_markup' =>  $backAdmin]);
            } else {
                $key[] =  [['text' => "🗝 نام قفل", 'callback_data' => "n"], ['text' => "⚙️ تغییر لینک", 'callback_data' => "n"], ['text' => "🗑 حذف", 'callback_data' => "n"]];
                $channel = $db->query("SELECT * FROM settings WHERE `type` = 'channel'");
                while ($row = $channel->fetch_assoc()) {
                    $chId = $row['type_id'];
                    $nameCh = $row['columnOne'];
                    $linkCh = $row['columnTwo'];
                    $key[] = [['text' => $nameCh, 'url' => $linkCh], ['text' =>  "⚙️", 'callback_data' => "changeLink_$chId"], ['text' =>  "🗑", 'callback_data' => "removeCh_$chId"]];
                }
                $key[] =  [['text' => "➕ افزودن قفل", 'callback_data' => "addCh+"]];
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "☑️ به بخش (🔒 بخش قفل ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - 🔗 برای تعییر لینک روی دکمه ی ( ⚙️ ) بزنید \n4 - برای افزودن قفل روی دکمه ی ( ➕ افزودن قفل ) بزنید", 'parse_mode' => 'MarkDown', 'reply_markup' => json_encode(['inline_keyboard' => $key])]);
            }
        }

        break;

    case "❌ بلاک کردن کاربر":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شناسه کاربر مورد نظر جهت بن شدن از ربات را ارسال کنید", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE user SET step = 'ban+' WHERE id = '$from_id'");
        }
        break;


    case "✅ آنبلاک کاربر":
        if ((in_array($from_id, Config::getAdmins()))) {
            $banuserscount = $db->query("SELECT * FROM user WHERE ban = 1");
            $Not = $db->query("SELECT * FROM user WHERE ban = 1")->fetch_assoc();
            if ($Not['id'] != false) {
                $key[] =  [['text' => "❕ آنبن کردن کاربر", 'callback_data' => "n"], ['text' => "👤 شناسه کاربر", 'callback_data' => "n"]];
                while ($row = $banuserscount->fetch_assoc()) {
                    $key[] = [['text' => "💢 انبن", 'callback_data' => "unban_{$row['id']}"], ['text' => $row['id'], 'callback_data' => "z"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 لیست کاربران بن شده به صورت زیر می باشد برای آنبن کردن کلیک کنید.", 'reply_markup' => json_encode(['inline_keyboard' => $key])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⭕️ فرد بن شده ای در ربات وجود ندارد!", 'parse_mode' => 'MarkDown', 'reply_markup' => $admin]);
            }
        }
        break;

    case "💎 وضعیت سرورها":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allServers = $db->query("SELECT * FROM servers")->fetch_assoc();
            if ($allServers) {
                @$selectServer = $db->query("SELECT * FROM servers");
                while ($row = $selectServer->fetch_assoc()) {
                    $button[] = [['text' => "{$row['name']}", 'callback_data' => "seeStats_{$row['id']}"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 برای دیدن وضعیت دقیق هرکدام از سرور ها، لطفا انتخاب کنید\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ سروری اضافه نکردید", 'reply_markup' => $admin]);
            }
        }

        break;


    case "💳 بخش درگاه ها":
        if ((in_array($from_id, Config::getAdmins()))) {
            $zarinPal = $db->query("SELECT * FROM settings WHERE `type` = 'zarinpal'")->fetch_assoc();
            $nextPay = $db->query("SELECT * FROM settings WHERE `type` = 'nexpay'")->fetch_assoc();
            $idPay = $db->query("SELECT * FROM settings WHERE `type` = 'idpay'")->fetch_assoc();
            $zibal = $db->query("SELECT * FROM settings WHERE `type` = 'zibal'")->fetch_assoc();
            $currency = $db->query("SELECT * FROM settings WHERE `type` = 'currency'")->fetch_assoc();
            $payOffline = $db->query("SELECT * FROM settings WHERE `type` = 'payOffline'")->fetch_assoc();
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']],
                [['text' => $zarinPal['type_id'], 'callback_data' =>  'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']],
                [['text' => $nextPay['type_id'], 'callback_data' =>  'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']],
                [['text' => $idPay['type_id'], 'callback_data' =>  'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']],
                [['text' => $zibal['type_id'], 'callback_data' =>  'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']],
                [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']],
                [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],
            ]]);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لطفا از طریق دکمه های زیر وضعیت فعال/غیرفعال کردن درگاه ها را مشخص کنید.", 'parse_mode' => 'html', 'reply_markup' => $status]);
        }
        break;


    case "⚙️ تنظیمات":
        if ((in_array($from_id, Config::getAdmins()))) {
            $bot = $db->query("SELECT * FROM settings WHERE `type` = 'bot'")->fetch_assoc();
            $phoneverify = $db->query("SELECT * FROM settings WHERE `type` = 'phoneVerify'")->fetch_assoc();
            $backup = $db->query("SELECT * FROM settings WHERE `type` = 'backup'")->fetch_assoc();
            $backUpDb = $db->query("SELECT * FROM settings WHERE `type` = 'backupDb'")->fetch_assoc();
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت", 'callback_data' => 'n'], ['text' => "🌟 نام", 'callback_data' => 'n']],
                [['text' => $bot['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_bot'], ['text' => "وضعیت ربات", 'callback_data' => 'n']],
                [['text' => $phoneverify['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_phoneVerify'], ['text' => "تایید شماره", 'callback_data' => 'n']],
                [['text' => $backup['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backup'], ['text' => "بک‌آپ از پنل x-ui", 'callback_data' =>  'n']],
                [['text' => $backUpDb['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backupDb'], ['text' => "بک‌آپ از دیتابیس ربات", 'callback_data' =>  'n']],
            ]]);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 لطفا از طریق دکمه های زیر وضعیت فعال/غیرفعال بودن را مشخص کنید.", 'parse_mode' => 'html', 'reply_markup' => $status]);
        }
        break;

    case "🔖 تنظیم سرور تانل":
        if ((in_array($from_id, Config::getAdmins()))) {
            $allservers = $db->query("SELECT * FROM servers")->fetch_assoc();
            if ($allservers) {
                @$selectServers = $db->query("SELECT * FROM servers");
                while ($row = $selectServers->fetch_assoc()) {
                    $button[] = [['text' => $row['name'], 'callback_data' => "setTunnel_{$row['id']}"]];
                }
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👈 جهت تنظیم دامنه/آیپی برای تانل روی کانکشن های ایجاد شده؛ یکی از سرور های زیر را انتخاب کنید:", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ شما هیچ سروری اضافه نکردید", 'reply_markup' => $admin]);
            }
        }
        break;

    case "/cancel_sending":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ صف ارسال پیام با موفقیت خالی شد اکنون میتوانید پیام خود را دوباره بفرستید", 'reply_markup' => $admin]);
            $db->query("UPDATE sendall SET step = '' , `text` = '' , user = '0' , `block` = '0' , chat = '', `type` = '', MsgId = '' , ChatID = ''");
            $db->query("UPDATE user SET step = '' WHERE id = '$from_id'");
        }
        break;

    case "👤 دریافت اطلاعات کاربر":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 آیدی عددی کاربر جهت نمایش اطلاعات را وارد کنید.", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE user SET step = 'userInfo' WHERE id = '$from_id'");
        }
        break;

    case "👤 پیام به کاربر":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 آیدی عددی کاربر جهت ارسال پیام را وارد کنید.", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE user SET step = 'sendDMtoUser' WHERE id = '$from_id'");
        }
        break;


    case "🌟 افزودن همکار":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 آیدی عددی شخص جهت اضافه شدن به لیست همکار ها را وارد کنید", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE user SET step = 'addCooperation' WHERE id = '$from_id'");
        }
        break;

    case "🗳 اکسپورت از شماره مشتری ها":
        if ((in_array($from_id, Config::getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⌛️", 'reply_markup' => $admin]);
            $allUser = $db->query("SELECT phone,id FROM user WHERE NOT phone = ''");
            $result = [];
            while ($row = $allUser->fetch_assoc()) {
                $res = [
                    "id" => $row['id'],
                    "phone" => $row['phone'],
                ];
                $result[] = $res;
            }
            file_put_contents('phone.json', json_encode($result));
            $MahdyarEn->sendDocument(['chat_id' => $from_id, 'document' => new CURLFile("phone.json")]);
            @unlink("phone.json");
        }
        break;
}

// Handling Step
switch ($step) {


        // adding plan - step 2
    case "addPlan2":
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ نام پلن با موفقیت ذخیره شد.\nلطفا قیمت پلن را وارد کنید (عدد 0 به معنای رایگان بودن می باشد)", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
        $db->multi_query("UPDATE user SET step = 'addPlan3' WHERE id = '$from_id';UPDATE settings SET columnOne = '$text' WHERE `type` = 'plan'");

        break;

        // adding plan - step 3
    case "addPlan3":
        if (is_numeric($text)) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ قیمت پلن با موفقیت ثبت شد.\n\nلطفا مشخصات سرویس را بصورت زیر وارد کنید:\n<code>vless-30-50-3-ws-tls|domain.com</code>\n🏷 توضیحات:\nمقدار اول (vless) : نوع پروتکل می باشد (تنها پروتکل های vmess-vless-trojan مورد پذیرش میباشد)\nمقدار دوم (30) : تعداد روز های اعتبار کانکشن (0 برای نامحدود بودن)\nمقدار سوم (50) : حجم کانفیگ ساخته شده به گیگابایت\nمقدار چهارم (3) : چند کاربره بودن کانکشن (0 برای نامحدود)\nمقدار پنجم (ws) : نوع انتقال شبکه تنها ws tcp grpc مجاز می باشد\nمقدار ششم (tls|domain.com) : نوع امنیت شبکه - در صورت وارد کردن xtls و یا tls دامنه را با علامت | جدا کنید. در صورتیکه نمیخواهید استفاده کنید مقدار none را بگذارید\n\n💎 درصورتی که قصد دارید روی یک پورت چند کلاینت ایجاد کنید مثل زیر عمل کنید:\n\n<code>vless-30-50-3-1</code>\n🏷 توضیحات:\nمقدار اول (vless) : نوع پروتکل می باشد (تنها پروتکل های vmess-vless مورد پذیرش میباشد)\nمقدار دوم (30) : تعداد روز های اعتبار کانکشن (0 برای نامحدود بودن)\nمقدار سوم (50) : حجم کانفیگ ساخته شده به گیگابایت\nمقدار چهارم (3) : چند کاربره بودن کانکشن (0 برای نامحدود\nمقدار پنجم (1): آیدی کانکشن در پنل xui\n‌", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
            $db->multi_query("UPDATE user SET step = 'addPlan4' WHERE id = '$from_id';UPDATE settings SET columnTwo = '$text' WHERE `type` = 'plan'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا بصورت عدد لاتین وارد کنید مانند: 3000", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
        }

        break;

        // adding plan - step 4
    case "addPlan4":
        $text  = explode('-', $text);
        @$plan = $db->query("SELECT * FROM settings WHERE `type` = 'plan'")->fetch_assoc();
        // vless-30-50-3-1

        if (count($text) == 5) {
            if (ctype_digit($text[1]) && ctype_digit($text[2]) && ctype_digit($text[3]) && ctype_digit($text[4])) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ پلن {$plan['columnOne']} با قیمت {$plan['columnTwo']} با موفقیت اضافه شد", 'parse_mode' => 'html', 'reply_markup' => $admin]);
                $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';INSERT INTO plan(`protocol`,`date`,`traffic`,`iplimit`,`serverid`,price,`name`,`rowid`) VALUES('$text[0]','$text[1]','$text[2]','$text[3]','{$plan['type_id']}','{$plan['columnTwo']}','{$plan['columnOne']}','$text[4]')");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا بجز مورد اول تمامی مورد ها باید بصورت عدد اینگلیسی وارد شود", 'reply_markup' => $backAdmin]);
            }
            // vless-30-50-3-ws-tls|domain.com

        } else if (count($text) == 6) {
            if (ctype_digit($text[1]) && ctype_digit($text[2]) && ctype_digit($text[3])) {
                $_ = explode('|', $text[5]);
                if ($_[0] == "none") {
                    $_[1] = "";
                }
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ پلن {$plan['columnOne']} با قیمت {$plan['columnTwo']} با موفقیت اضافه شد", 'parse_mode' => 'html', 'reply_markup' => $admin]);
                $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';INSERT INTO plan(`protocol`,`date`,`traffic`,`iplimit`,`serverid`,price,`name`,`domain`,`network`,`security`) VALUES('$text[0]','$text[1]','$text[2]','$text[3]','{$plan['type_id']}','{$plan['columnTwo']}','{$plan['columnOne']}','$_[1]','$text[4]','$_[0]')");
            } else {

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا بجز مورد اول تمامی مورد ها باید بصورت عدد اینگلیسی وارد شود", 'reply_markup' => $backAdmin]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا هر یک از 3 مورد خواسته شده را در یک خط جدا وارد کنید", 'reply_markup' => $backAdmin]);
        }

        break;


    case "addTestPlan2":
        $text  = explode('-', $text);
        @$plan = $db->query("SELECT * FROM settings WHERE `type` = 'plan'")->fetch_assoc();
        // vless-30-50-3-1

        if (count($text) == 5) {
            if (ctype_digit($text[1]) && ctype_digit($text[2]) && ctype_digit($text[3]) && ctype_digit($text[4])) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎁 پلن تستی با ترافیک {$text[2]} مگابایت ایجاد شد", 'parse_mode' => 'html', 'reply_markup' => $admin]);
                $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';INSERT INTO plan(`protocol`,`date`,`traffic`,`iplimit`,`serverid`,price,`name`,`rowid`) VALUES('$text[0]','$text[1]','$text[2]','$text[3]','{$plan['type_id']}','0','testService','$text[4]')");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا بجز مورد اول تمامی مورد ها باید بصورت عدد اینگلیسی وارد شود", 'reply_markup' => $backAdmin]);
            }
            // vless-30-50-3-ws-tls|domain.com

        } else if (count($text) == 6) {
            if (ctype_digit($text[1]) && ctype_digit($text[2]) && ctype_digit($text[3])) {
                $_ = explode('|', $text[5]);
                if ($_[0] == "none") {
                    $_[1] = "";
                }
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎁 پلن تستی با ترافیک {$text[2]} مگابایت ایجاد شد", 'parse_mode' => 'html', 'reply_markup' => $admin]);
                $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';INSERT INTO plan(`protocol`,`date`,`traffic`,`iplimit`,`serverid`,price,`name`,`domain`,`network`,`security`) VALUES('$text[0]','$text[1]','$text[2]','$text[3]','{$plan['type_id']}','{$plan['columnTwo']}','testService','$_[1]','$text[4]','$_[0]')");
            } else {

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا بجز مورد اول تمامی مورد ها باید بصورت عدد اینگلیسی وارد شود", 'reply_markup' => $backAdmin]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا هر یک از 3 مورد خواسته شده را در یک خط جدا وارد کنید", 'reply_markup' => $backAdmin]);
        }
        break;

        // adding server - step 1
    case "addServer":
        @$text  = explode("\n", $text);
        if (count($text) < 3) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا هر یک از 3 مورد خواسته شده را در یک خط جدا وارد کنید", 'reply_markup' => $backAdmin]);
        } elseif (!ctype_digit($text[1])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا ظرفیت سرور باید بصورت عددی لاتین و بزرگتر از صفر وارد شود مانند: 35", 'reply_markup' => $backAdmin]);
        } elseif (!preg_match('/^[a-zA-Z0-9_]+$/', $text[2])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا نام کانکشن های ساخته شده باید بصورت اینگلیسی و بدون فاصله باشد مانند: <code>GermanServer</code>", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        } else {
            $hostValue = $text[3] ? $text[3] : '';
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📂 حالا آدرس پنل xi را همراه با پورت وارد کنید ( با http و یا https)\n\n🏷 مثال: \n<code>https://mypanel.domain.com:1234</code>\nو یا:\n<code>http://31.561.234.12:1234</code>\n", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
            $db->multi_query("UPDATE user SET step = 'addServer-2' WHERE id = '$from_id';UPDATE settings SET type_id = '$text[0]|$text[1]|$text[2]|$hostValue' WHERE `type` = 'server'");
        }

        break;

        // adding server - step 2

    case "addServer-2":
        if (!filter_var($text, FILTER_VALIDATE_URL)) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا آدرس ارسالی صحیح نمی باشد", 'reply_markup' => $backAdmin]);
        } else {
            $msgId = $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️"])['result']['message_id'];;
            if ($MahdyarEn->getUrlStatus($text) == 200) {
                $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $msgId, 'text' => "🔐 حال یوزرنیم پنل را ارسال کنید"]);
                $db->multi_query("UPDATE user SET step = 'addServer-3' WHERE id = '$from_id';UPDATE settings SET columnOne = '$text' WHERE `type` = 'server'");
            } else {
                $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $msgId, 'text' => "⚠️ خطا در برقراری ارتباط با پنل ( لطفا دسترسی هاست به این پورت را بررسی کنید )"]);
            }
        }

        break;

        // adding server - step 3

    case "addServer-3":
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🔐 حال پسورد پنل را ارسال کنید", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        $db->multi_query("UPDATE user SET step = 'addServer-4' WHERE id = '$from_id';UPDATE settings SET columnTwo = '$text' WHERE `type` = 'server'");
        break;

        // adding server - step 4
    case "addServer-4":
        $text = $MahdyarEn->Text();
        @$server = $db->query("SELECT * FROM settings WHERE `type` = 'server'")->fetch_assoc();
        $info = explode('|', $server['type_id']);
        $url = explode(':', str_replace(array("http://", "https://"), "", $server['columnOne']));
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "📂 اطلاعات سرور:\n\n📎 آدرس سرور: $url[0]\n📌 پورت سرور: $url[1]\n👤 یوزرنیم پنل: <tg-spoiler>{$server['columnTwo']}</tg-spoiler>\n🔐 پسورد پنل: <tg-spoiler>$text</tg-spoiler>\n‌", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال اتصال به سرور...", 'reply_markup' => $backAdmin]);
        $xui = ConnectXui($server['columnOne'], $server['columnTwo'], $text);
        $result = $xui->listInbound();
        if ($result['success'] == true) {
            $hostValue = $info[3] ? $info[3] : '';
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "سرور شما با موفقیت به لیست سرور ها افزوده شد", 'reply_markup' => $admin]);
            $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';INSERT INTO servers(`name`,`max`,`remark`,`link`,`username`,`password`,`host`) VALUES('$info[0]','$info[1]','$info[2]','{$server['columnOne']}','{$server['columnTwo']}','$text','$hostValue')");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی در اتصال به سرور پیش آمد، لطفا از درست بودن اطلاعات مطمئن شوید ", 'reply_markup' => $admin]);
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        }
        break;

    case "tunnel":
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت ثبت شد، از این پس کانکشن های ایجاد شده روی آیپی/دامنه فوق تنظیم خواهند شد.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
        $db->multi_query("UPDATE user SET step = '' WHERE id = '$from_id';UPDATE settings SET type_id = '$text' WHERE `type` = 'tunnel'");
        break;

        // verify user phone number
    case "phone+":
        if ($contact) {
            if ($contactho == $from_id) {
                $contactnum = str_replace('+', '', $contactnum);
                if ($contactnum[0] . $contactnum[1] == "98") {
                    $db->query("UPDATE user SET phone = '$contactnum', step = 'none' WHERE id = '$from_id' ");

                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎉 تبریک حساب شما تایید شد.\n\n👇 از این پس قادر هستید از تمامی امکانات ربات، بدون محدودیت استفاده کنید.\n‌", 'reply_markup' => $home]);
                } else {
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️خطا! تنها شماره های ایرانی تایید خواهند شد.", 'reply_markup' => $home]);
                }
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا با استفاده از دکمه زیر اقدام به ثبت شماره خود نمایید 👇 ", 'reply_markup' => $pay_false]);
            }
        }
        break;

        // payment - Shaparak
    case "payShaparak":
        if (!isset($data)) {
            if ($text >= 5000 and $text <= 1000000 and is_numeric($text)) {
                $amount = intval($text);
                $factor_number = uniqid();
                $zarinPal = $db->query("SELECT * FROM settings WHERE `type` = 'zarinpal'")->fetch_assoc();
                $nextPay = $db->query("SELECT * FROM settings WHERE `type` = 'nexpay'")->fetch_assoc();
                $idPay = $db->query("SELECT * FROM settings WHERE `type` = 'idpay'")->fetch_assoc();
                $zibal = $db->query("SELECT * FROM settings WHERE `type` = 'zibal'")->fetch_assoc();
                $pay_keyboard = [];
                if ($zarinPal['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با زرین پال", 'url' => Config::HOST_URL . "/pay/pay.php?type=zarinpal&factor=$factor_number"]];
                if ($nextPay['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با نکست پی", 'url' => Config::HOST_URL . "/pay/pay.php?type=nexpay&factor=$factor_number"]];
                if ($idPay['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با آیدی پی", 'url' => Config::HOST_URL . "/pay/pay.php?type=idpay&factor=$factor_number"]];
                if ($zibal['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با زیبال", 'url' => Config::HOST_URL . "/pay/pay.php?type=zibal&factor=$factor_number"]];
                if (count($pay_keyboard) == 0) {
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر درگاه فعالی وجود ندارد، لطفا بعدا اقدام به پرداخت کنید و یا از سایر روش های پرداخت استفاده کنید.", 'reply_markup' => $home]);
                } else {
                    $pay_keyboard  = json_encode(['inline_keyboard' => $pay_keyboard]);
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ $amount تومان با #موفقیت صادر گردید.\n\n📂 شماره فاکتور: <code>$factor_number</code>\n\n⏳ فاکتور صادر شده تنها 30 دقیقه اعتبار دارد.\n\nدرصورت #تایید پرداخت کنید 👇", 'parse_mode' => 'html', 'reply_markup' => $pay_keyboard]);
                    $expire = time() + 1800;
                    $db->query("INSERT into pay(id,amount,factor,`time`) VALUES('$from_id','$amount','$factor_number','$expire')");
                }
                $db->query("UPDATE user SET step = 'none'  WHERE id = '$from_id'");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⚠️ خطا! لطفا مبلغ را بصورت لاتین (123) و بین 5,000 الی 1,000,000 تومان وارد کنید.", 'reply_markup' => $back]);
            }
        }
        break;

        // Payment Currency
    case "payCurrency":
        if (!isset($data)) {
            if ($text >= 5000 and $text <= 1000000 and is_numeric($text)) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال محاسبه قیمت..."]);
                $url = file_get_contents("https://www.tgju.org/%D9%82%DB%8C%D9%85%D8%AA-%D8%AF%D9%84%D8%A7%D8%B1");
                $preg_match = preg_match_all('#data-price="(.*?)"#', $url, $dolar);
                $amount = intval($text);
                $factor_number = uniqid();
                $USD = intval(str_replace(",", "", $dolar[1][0])) / 10;
                $amountUSD = $amount / $USD;
                $amountUSD = number_format($amountUSD, 4);
                $wageAnount = 0.09 * $amountUSD;
                $finalPrice =  number_format($amountUSD + $wageAnount, 4);
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ فاکتور پرداخت ارزی NOWPayments ایجاد شد.\n\n📂 شماره فاکتور: $factor_number\n💰مبلغ فاکتور: $amount تومان\n\n💴 قیمت دلار: {$USD} تومان\n🔖 کارمزد 9% معادل $wageAnount دلار\n💳 مبلغ نهایی (با احتساب کارمزد): $finalPrice دلار\n\n⏳ فاکتور صادر شده تنها 30 دقیقه اعتبار دارد.\n\n🛒 امکان پرداخت با ارز های مختلف ( ETH , BTC , USDT , TRX و... ) وجود دارد\n\nدرصورت #تایید پرداخت کنید 👇", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "🔗 پرداخت", 'url' => Config::HOST_URL . "/pay/pay.php?factor=$factor_number"]]]])]);
                $db->query("UPDATE user SET step = 'none'  WHERE id = '$from_id'");
                $expire = time() + 1800;
                $db->query("INSERT into pay(id,amount,factor,`time`,`type`,usd) VALUES('$from_id','$amount','$factor_number','$expire','nowpayment','$finalPrice')");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⚠️ خطا! لطفا مبلغ را بصورت لاتین (123) و بین 5,000 الی 1,000,000 تومان وارد کنید.", 'reply_markup' => $back]);
            }
        }
        break;

    case "payOffline":
        if (!isset($data)) {
            if ($text >= 5000 and $text <= 1000000 and is_numeric($text)) {
                $amount = intval($text);
                $factor_number = uniqid();
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ $amount تومان با #موفقیت صادر گردید.\n\n📂 شماره فاکتور: <code>$factor_number</code>\n\nشماره کارت: " . Config::CARD_NUMBER . "\nبه نام: " . Config::CARD_NAME . "\nپس از پرداخت فیش را همینجا ارسال کنید 👇", 'reply_markup' => $back, 'parse_mode' => 'html']);
                $db->query("UPDATE user SET step = 'sendFish_{$chat_id}_$factor_number'  WHERE id = '$from_id'");
                $expire = time() + 9000000;
                $db->query("INSERT into pay(id,amount,factor,`time`) VALUES('$from_id','$amount','$factor_number','$expire')");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⚠️ خطا! لطفا مبلغ را بصورت لاتین (123) و بین 5,000 الی 1,000,000 تومان وارد کنید.", 'reply_markup' => $back]);
            }
        }
        break;



        // send to all
    case "send+":
        if ($updateType != 'forward' and !isset($data)) {
            $alluser = $db->query("SELECT id from user")->num_rows;
            $timedone = $alluser < 100 ? 'یک دقیقه' : $MahdyarEn->getTime(round(($alluser / 100)) * 60);
            $msgIDtext = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "〽️ پیام شما درحال ارسال به $alluser نفر می باشد.\n\n⏳ زمان تقریبی پایان عملیات: $timedone\n\n⏱ این پیام هر یک دقیقه آپدیت میشود.\n‌", 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❌ لغو ارسال", 'callback_data' => "cancelSending"]],]])])['result']['message_id'];
            $db->query("UPDATE sendall SET step = 'send' ,`text` = '$message_id',chat = '$chat_id', MsgId = '$msgIDtext' , ChatID = '$from_id'");
        }
        break;

        // forward to all
    case "forward+":
        if (!isset($data)) {
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
            $alluser = $db->query("SELECT id from user")->num_rows;
            $timedone = $alluser < 100 ? 'یک دقیقه' : $MahdyarEn->getTime(round(($alluser / 100)) * 60);
            $msgIDtext = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "〽️ پیام شما درحال فوروارد به $alluser نفر می باشد.\n\n⏳ زمان تقریبی پایان عملیات: $timedone\n\n⏱ این پیام هر یک دقیقه آپدیت میشود.\n‌", 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❌ لغو ارسال", 'callback_data' => "cancelSending"]],]])])['result']['message_id'];
            $db->query("UPDATE sendall SET step = 'forward' ,`text` = '$message_id',chat = '$chat_id', MsgId = '$msgIDtext' , ChatID = '$from_id'");
        }
        break;


        // increase user stock
    case "sendDMtoUser":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 پیام خود را در قالب متن، عکس، ویدیو، گیف، استیکر و... ارسال کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'sendDM_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

        // increase user stock
    case "increaseStock":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 خب حالا مقدار موجودی که میخواهید به کاربر اضافه شود را وارد کنید (به تومان)", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'increase_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

        // decrease user stock
    case "decrease":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 خب حالا مقدار موجودی که میخواهید از کاربر کم شود را وارد کنید (به تومان)", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'decrease_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

        // adding exempt 
    case "addExempt":
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
        $_ = $db->query("SELECT * FROM `settings` WHERE `type`= 'exempt'")->fetch_assoc();
        $allExempt = $_['type_id']  . $text . '|';
        $db->query("UPDATE `settings` SET `type_id` = '$allExempt' WHERE `type`= 'exempt'");
        $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text)  از جوین اجباری معاف شد.", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        break;

        // remove exempt 
    case "removeExemp":
        if (isset($data)) {
            $allExempt = str_replace($data . '|', '', $db->query("SELECT * FROM `settings` WHERE `type`= 'exempt'")->fetch_assoc()['type_id']);
            $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `settings` SET `type_id` = '$allExempt' WHERE `type` = 'exempt'");
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) از لیست معاف ها حذف شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        }
        break;

        // adding admin 
    case "addAdmin+":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser["id"]) {
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
            $_ = $db->query("SELECT * FROM `settings` WHERE `type`= 'admin'")->fetch_assoc();
            $allAdmins = $_['type_id']  . $text . '|';
            $db->query("UPDATE `settings` SET `type_id` = '$allAdmins' WHERE `type`= 'admin'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) ادمین ربات شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "✅ شما به لیست ادمین های ربات اضافه شدید", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

        // remove specific admin
    case "removeAdmin+":
        if (isset($data)) {
            $allAdmins = str_replace($data . '|', '', $db->query("SELECT * FROM `settings` WHERE `type`= 'admin'")->fetch_assoc()['type_id']);
            $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `settings` SET `type_id` = '$allAdmins' WHERE `type` = 'admin'");
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) از لیست ادمین ها حذف شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "❌ شما از لیست ادمین های ربات حذف شدید", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
        break;

    case "removeCooperation":
        if (isset($data)) {
            $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `user` SET `cooperation` = '0' WHERE `id` = '$data'");
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) از لیست همکار ها حذف شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        }
        break;

        // support
    case "suport+":
        if ($updateType != 'forward') {
            $firstAdmin = Config::getAdmins()[0];
            $btnAnswrer  = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
                [['text' => "پاسخ به کاربر 👤", 'callback_data' => "support|$chat_id|$message_id"]],
            ]]);
            $theUser = "[پیوی کاربر](tg://user?id=$chat_id)\nآیدی عددی کاربر: `$chat_id`";
            switch ($updateType) {
                case "message":
                    $MahdyarEn->sendMessage(['chat_id' => $firstAdmin, 'text' => "$text\n$theUser", 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "photo":
                    $MahdyarEn->sendPhoto(['chat_id' => $firstAdmin, 'photo' => $photo_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "video":
                    $MahdyarEn->sendVideo(['chat_id' => $firstAdmin, 'video' => $video_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "sticker":
                    $MahdyarEn->sendSticker(['chat_id' => $firstAdmin, 'sticker' => $sticker_id, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    $MahdyarEn->sendMessage(['chat_id' => $firstAdmin, 'text' => "استیکر بالا توسط کاربر زیر فرستاده شده است:\n$theUser", 'parse_mode' => 'MarkDown']);

                    break;

                case "voice":
                    $MahdyarEn->sendVoice(['chat_id' => $firstAdmin, 'voice' => $voice_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "document":
                    $MahdyarEn->sendDocument(['chat_id' => $firstAdmin, 'document' => $file_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "audio":
                    $MahdyarEn->sendAudio(['chat_id' => $firstAdmin, 'audio' => $audio_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;

                case "animation":
                    $MahdyarEn->sendAnimation(['chat_id' => $firstAdmin, 'animation' => $gif_id, 'caption' =>  $caption . "\n" . $theUser, 'reply_markup' => $btnAnswrer, 'parse_mode' => 'MarkDown']);
                    break;
            }
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ پیام شما برای پشتیبانی ارسال شد، لطفا برای دریافت پاسخ صبور باشید\nاگر هنوز قصد مکالمه دارید، پیام خود را وارد کنید", 'reply_markup' => $back]);
        }
        break;
    case "ban+":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser["id"]) {
            if ($selecteduser["ban"] != '1') {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⭕️ [کاربر مورد نظر شما](tg://user?id=$text) با موفقیت از ربات بن شد.", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
                $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "⚠️ حساب شما توسط ادمین بن شد", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['KeyboardRemove' => [], 'remove_keyboard' => true])]);
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
                $db->query("UPDATE user SET ban = '1' WHERE id = '$text'");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "🚫این کاربر از قبل از ربات بن شده بود!", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }

        break;


    case "userInfo":
        @$selectUser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selectUser["id"]) {
            @$configCount = $db->query("SELECT id FROM config WHERE user = '$text'")->num_rows;
            @$getchat = $MahdyarEn->getChat(['chat_id' => $selectUser['id']])['result'];
            @$username = $getchat['username'] ? '@' . $getchat['username'] : 'ندارد';
            @$first_name = $getchat['first_name'] ?  $getchat['first_name'] : 'ندارد';
            @$last_name = $getchat['last_name'] ?  $getchat['last_name'] : 'ندارد';
            @$profile = $MahdyarEn->getUserProfilePhotos(['user_id' => $selectUser['id']])['result']['photos'][0][0]['file_id'];
            @$phoneStatus = $selectUser['phone'] ? 'تایید شده است' : 'تایید نشده است';
            if ($profile != null) {
                $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $profile, 'caption' => "اطلاعات <a href='tg://user?id={$selectUser['id']}'>کاربر</a> انتخاب شده به شرح زیر می باشد\n👤 نام کاربر: $first_name\n👨‍👨‍👦‍👦 نام خانوادگی: $last_name\n🔐 یوزرنیم کاربر: $username\nوضعیت تایید شماره: $phoneStatus\n🛍 تعداد کانفیگ های کاربر: $configCount\n💳 موجودی کاربر: {$selectUser['stock']} تومان\n👥 تعداد زیرمجموعه های کاربر : {$selectUser['invite']}\n‌",  'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => "دیدن لیست سرویس ها", 'callback_data' => "userServices_$text"]],
                ]]), 'parse_mode' => 'html']);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "اطلاعات <a href='tg://user?id={$selectUser['id']}'>کاربر</a> انتخاب شده به شرح زیر می باشد\n👤 نام کاربر: $first_name\n👨‍👨‍👦‍👦 نام خانوادگی: $last_name\n🔐 یوزرنیم کاربر: $username\nوضعیت تایید شماره: $phoneStatus\n🛍 تعداد کانفیگ های کاربر: $configCount\n💳 موجودی کاربر: {$selectUser['stock']} تومان\n👥 تعداد زیرمجموعه های کاربر : {$selectUser['invite']}\n‌", 'reply_markup' => $admin, 'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => "دیدن لیست سرویس ها", 'callback_data' => "userServices_$text"]],
                ]]), 'parse_mode' => 'html']);
            }
            if ($selectUser['phone']) {
                $MahdyarEn->sendContact(['chat_id' => $chat_id, 'phone_number' => $selectUser['phone'], 'first_name' => $first_name]);
            }
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }

        break;


    case "addCooperation":
        @$selectUser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selectUser["id"]) {
            if ($selecteduser["cooperation"] != '1') {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ [کاربر مورد نظر شما](tg://user?id=$text) با موفقیت به لیست همکار ها اضافه شد.", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
                $db->multi_query("UPDATE user SET step = 'none' WHERE id = '$from_id';UPDATE user SET cooperation = '1' WHERE id = '$text'");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⭕️ کاربر از قبل در لیست همکار ها قرار داشت", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;


    case "addDiscount":
        $text  = explode("\n", $text);
        if (count($text) < 3) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا هر یک از 3 مورد خواسته شده را در یک خط جدا وارد کنید", 'reply_markup' => $backAdmin]);
        } elseif (!ctype_digit($text[1])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا درصد تخفیف باید بصورت عددی لاتین و بزرگتر از صفر وارد شود مانند: 30", 'reply_markup' => $backAdmin]);
        } elseif (!ctype_digit($text[2])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا! حداکثر استفاده باید بصورت عدد لاتین و بزرگتر تر از صفر باشد", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎁 کد تخفیف <code>$text[0]</code> با $text[1] درصد تخفیف برای استفاده $text[2] نفر ایجاد شد.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
            $db->multi_query("INSERT INTO settings(`type`,`type_id`,`columnOne`,`columnTwo`) VALUES('discount','{$text[0]}','{$text[1]}','{$text[2]}|0');UPDATE user SET step = 'none' WHERE id = '$from_id'");
        }
        break;
}

// 

if ((strstr($text, 'vless://') or strstr($text, 'vmess://'))) {
    if (strstr($text, 'vless://')) {
        preg_match('#vless\:\/\/(.*)\@(.*)\:(.*)\?(.*)\#(.*)#', $text, $matchs);
        $text = $matchs[0];
        $uid = $matchs[1];
        $domain = $matchs[2];
        $port = $matchs[3];
        $remark = urldecode($matchs[5]);
    } else {
        $params = json_decode(base64_decode(str_replace('vmess://', "", $text)), true);
        $uid = $params['id'];
        $domain = $params['add'];
        $port = $params['port'];
        $remark = urldecode($params['ps']);
    }
    if (is_numeric($port)) {
        $selectServer = $db->query("SELECT servers.link,servers.host,servers.username,servers.password FROM plan JOIN servers ON plan.serverid = servers.id WHERE (plan.domain LIKE '%$domain%' or servers.link LIKE '%$domain%')")->fetch_assoc();
        if (empty($selectServer['link'])) {
            $selectServer = $db->query("SELECT servers.link,servers.host,servers.username,servers.password FROM plan JOIN servers ON plan.serverid = servers.id  JOIN config ON config.planid = plan.id WHERE config.link LIKE '%$uid%'")->fetch_assoc();
        }
        if (!empty($selectServer['link'])) {
            $msgId = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "در حال جستجو سرویس مورد نظر شما .. 🔍"])['result']['message_id'];
            //    connect to xui panel api
            $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
            $result = $xui->list(['port' => (int)$port])[0];
            if ($result['id']) {
                if (count($result['clientStats']) == 1) {
                    $totalTr = $result['total'];
                    $upTr =  $result['up'];
                    $down =  $result['down'];
                    $expire =  $result['expiryTime'];
                    $status =  $result['enable'];
                } else {
                    $clientStats = $result["clientStats"];
                    $clients =  json_decode($result['settings'], true)['clients'];
                    $cli = $clients[array_search($uid, array_column($clients, 'id'))];
                    $cIndex = $xui->getClientStatsIndexByEmail($clientStats, $cli['email']);
                    if (!$cIndex) {
                        $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $msgId], ['chat_id' => $from_id, 'text' => "سرویس مورد نظر شما جزء سرویس های ربات نمی باشد و یا غیرقابل دسترسی است"]);
                        exit();
                    }
                    $client = $clientStats[$cIndex];
                    $totalTr =  $client['total'];
                    $upTr =  $client['up'];
                    $down =  $client['down'];
                    $expire =  $client['expiryTime'];
                    $status =  $client['enable'];
                    if (!$cli['enable']) $status = false;
                }
                $REMAIN = $totalTr - $upTr - $down;
                if ($REMAIN == 0 && $totalTr != 0) $status = false;
                $expireD =  ($expire / 1000) - strtotime(date('Y/m/d H:i', time()));
                $expireText = $expire == 0 ? 'بدون تاریخ انقضا' : jdate('l j F Y', $expire / 1000);
                $countDown = '';

                if ($expireD > 0 && $expire != 0) {
                    $countDown = $MahdyarEn->getTime($expireD) . ' دیگر';
                } else {
                    $countDown = 'منقضی شده است';
                }
                if ($countDown) $expireText .= " ($countDown) ";

                if ($totalTr == 0) {
                    $totalTr = "نامحدود";
                    $REMAIN = "نامحدود";
                    $show_down = getSize($down);
                    $show_upTr = getSize($upTr);
                } else {
                    $REMAIN = getSize($REMAIN);
                    $totalTr = getSize($totalTr);
                    $show_down = getSize($down);
                    $show_upTr = getSize($upTr);
                }
                @$selectConfig = $db->query("SELECT * FROM config WHERE link LIKE '%$uid%'")->fetch_assoc();
                $key = [
                    [['text' => $status ? '🟢 فعال' : '⭕ غیرفعال', 'callback_data' => 'n'], ['text' => "💎 وضعیت سرویس", 'callback_data' => 'n']],
                    [['text' => $totalTr, 'callback_data' => 'n'], ['text' => "🏷 حجم سرویس", 'callback_data' => "n"]],
                    [['text' => getSize($down + $upTr), 'callback_data' => 'n'], ['text' => "📥 حجم مصرفی", 'callback_data' => 'n']],
                    [['text' => $REMAIN, 'callback_data' => 'n'], ['text' => "📥 حجم باقی مانده", 'callback_data' => 'n']],
                    [['text' => $countDown, 'callback_data' => 'n'], ['text' => "🗓 زمان انقضا", 'callback_data' => "n"]],
                ];
                if ($selectConfig['code'] && $selectConfig['user'] == $from_id) {
                    $key[] =  [['text' => "مدیریت سرویس", 'callback_data' => "manageService_{$selectConfig['code']}"]];
                }
                if ((in_array($from_id, Config::getAdmins()))) {
                    $key[] =  [['text' => "⭕ حذف سرویس کاربر", 'callback_data' => "delService_{$selectConfig['id']}"]];
                }
                $key = json_encode(['inline_keyboard' => $key]);
                $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $msgId], ['chat_id' => $from_id, 'text' => "👇 اطلاعات سرویس شما به شرح زیر می باشد:\n\n💎 حجم کل سرویس: $totalTr\n\n📉 میزان دانلود: $show_down\n📈 میزان آپلود: $show_upTr\n\n🔖 حجم باقی مانده: $REMAIN\n🗓 تاریخ انقضای سرویس: $expireText\n‌", 'parse_mode' => 'html', 'reply_markup' => @$key]);
            } else
                $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $msgId], ['chat_id' => $from_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمد لطفا به پشتیبانی اطلاع دهید"]);
        } else
            $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $msgId], ['chat_id' => $from_id, 'text' => "سرویس مورد نظر شما جزء سرویس های ربات نمی باشد و یا غیرقابل دسترسی است"]);
    } else
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "فورمت ارسالی سرویس موردنظر شما صحیح نمی باشد"]);
}

// ---- Handling Step 2 ----


// select plan to buy
if (strpos($step, 'sendFish_') !== false) {
    $explode = explode('_', $step);
    $selectFactor = $db->query("SELECT * FROM pay WHERE factor = '$explode[2]'")->fetch_assoc();

    if ($updateType == "photo") {
        $msgID = $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "فیش شما ارسال شد. منتظر تایید باشید ✅", 'reply_markup' => $explode[3] ? null : $home])['result']['message_id'];
        $_ = $explode[3] ? "payTrue_$explode[1]_$explode[2]_{$msgID}_$from_id" : "payTrue_$explode[1]_$explode[2]";
        $key = json_encode(['inline_keyboard' => [
            [['text' => "تایید پرداخت", 'callback_data' => "$_"]],
            [['text' => "⭕️ مشکل در پرداخت", 'callback_data' => "payFalse_$explode[1]_$message_id"]],
        ]]);
        $MahdyarEn->sendPhoto(['chat_id' => Config::CHANNEL_PAY, 'photo' => $photo_id, 'caption' => $caption . "\n\n#پرداخت_جدید\n👤 کاربر: <a href='tg://user?id=$explode[1]'>$explode[1]</a>\n📂 شماره فاکتور: $explode[2]\n💳 مبلغ: {$selectFactor['amount']}", 'reply_markup' => $key, 'parse_mode' => 'html']);
        if ($explode[3]) {
            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => "✅ تایید سفارش", 'callback_data' => "verifyPay*{$explode[3]}*{$explode[4]}*{$explode[2]}"]]
            ]]);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🌟 پس از تایید شدن فاکتور، میتوانید جهت ساخت سرویس مورد نظرتون بر روی دکمه «✅ تایید سفارش» کلیک کنید", 'reply_markup' => $keyboard]);
        }
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا فیش خود را در قالب عکس ارسال کنید", 'reply_markup' => $back]);
    }
} else if (strpos($step, 'sendDM_') !== false) {
    $explode = explode('_', $step);
    switch ($updateType) {
        case "message":
            $MahdyarEn->sendMessage(['chat_id' => $explode[1], 'text' => "$text",  'parse_mode' => 'MarkDown']);
            break;

        case "photo":
            $MahdyarEn->sendPhoto(['chat_id' => $explode[1], 'photo' => $photo_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "video":
            $MahdyarEn->sendVideo(['chat_id' => $explode[1], 'video' => $video_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "sticker":
            $MahdyarEn->sendSticker(['chat_id' => $explode[1], 'sticker' => $sticker_id,  'parse_mode' => 'MarkDown']);
            break;

        case "voice":
            $MahdyarEn->sendVoice(['chat_id' => $explode[1], 'voice' => $voice_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "document":
            $MahdyarEn->sendDocument(['chat_id' => $explode[1], 'document' => $file_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "audio":
            $MahdyarEn->sendAudio(['chat_id' => $explode[1], 'audio' => $audio_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "animation":
            $MahdyarEn->sendAnimation(['chat_id' => $explode[1], 'animation' => $gif_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;
    }
    // $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✋ پیام شما برای کاربر ( <a href='tg://user?id=$explode[1]'>$explode[1]</a> ) ارسال شد.\nدرصورت نیاز پیام بعدی خود را ارسال کنید",  'parse_mode' => 'html', 'reply_markup' => $back]);
}
// increase user stock
else if (strpos($step, 'increase_') !== false) {
    $explode = explode('_', $step);
    $_ = $db->query("SELECT * FROM user WHERE `id` = '$explode[1]'")->fetch_assoc();
    if (is_numeric($text)) {
        $newStock =  $_['stock'] + $text;
        $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "✅ موجودی شما به مقدار $text تومان افزایش یافت"]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ موجودی کاربر افزایش یافت، موجودی جدید کاربر: $newStock", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $db->query("UPDATE user SET stock = stock + $text WHERE id = '$explode[1]'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "❌ مقدار عددی وارد کنید", 'reply_markup' => $backAdmin]);
    }
}
// decrease user stock
else if (strpos($step, 'decrease_') !== false) {
    $explode = explode('_', $step);
    $_ = $db->query("SELECT * FROM user WHERE `id` = '$explode[1]'")->fetch_assoc();

    if (is_numeric($text)) {
        $newStock =  $_['stock'] - $text;
        $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "⭕️ موجودی شما به مقدار $text کاهش یافت"]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ موجودی کاربر کاهش یافت، موجودی جدید کاربر: $newStock", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $db->query("UPDATE user SET stock = stock - $text WHERE id = '$explode[1]'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "❌ مقدار عددی وارد کنید", 'reply_markup' => $backAdmin]);
    }
} else if (strpos($step, 'tunnel~') !== false) {
    $explode = explode('~', $step);
    if ($text == '0') {
        $txt = "⭕️ سرور تانل حذف شد";
    } else {
        $txt = "✅ سرور تانل با موفقیت تنظیم شد";
    }
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "$txt", 'parse_mode' => 'html', 'reply_markup' => $admin]);
    $db->multi_query("UPDATE `servers` SET `tunnel` = '$text' WHERE id = '$explode[1]';UPDATE user SET step = 'none' WHERE id = '$from_id'");
}

// change server information
else if (strpos($step, 'change|') !== false) {
    $explode = explode('|', $step);
    $ok = false;
    switch ($explode[1]) {
        case  "name":
            $name = "نام سرور";
            $ok = true;
            break;

        case  "host":
            $name = "هاست سرور";
            $ok = true;
            break;

        case  "max":
            $name = "حداکثر حجم";
            if (!ctype_digit($text[1])) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا ظرفیت سرور باید بصورت عددی لاتین و بزرگتر از صفر وارد شود مانند: 35", 'reply_markup' => $backAdmin]);
            } else {
                $ok = true;
            }
            break;
        case  "remark":
            $name = "ریمارک";
            if (!preg_match('/^[a-zA-Z0-9_]+$/', $text[2])) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا نام کانکشن های ساخته شده باید بصورت اینگلیسی و بدون فاصله باشد مانند: <code>GermanServer</code>", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
            } else {
                $ok = true;
            }
            break;
        case  "username":
            $name = "یوزرنیم سرور";
            $ok = true;
            break;
        case  "password":
            $name = "پسورد سرور";
            $ok = true;
            break;

        case  "link":
            $name = "لینک سرور";
            if (!filter_var($text, FILTER_VALIDATE_URL)) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ آدرس پنل xi را همراه با پورت وارد کنید ( با http و یا https)\n\n🏷 مثال: \n<code>https://mypanel.domain.com:1234</code>\nو یا:\n<code>http://31.561.234.12:1234</code>\n", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
            } else {
                $ok = true;
            }
            break;
    }
    if ($ok) {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت تغییر یافت.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
        $db->query("UPDATE `servers` SET `$explode[1]` = '$text' WHERE id = '$explode[2]'");
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
    }
}
// change plan information

else if (strpos($step, 'changePlan|') !== false) {
    $explode = explode('|', $step);
    $ok = false;
    switch ($explode[1]) {
        case  "name":
        case  "domain":
            $ok = true;
            break;
        case  "protocol":
            if ($text == "vless" || $text == "vmess" || $text == "trojan") {
                $ok = true;
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا پروتکل کانفیگ را با دقت وارد کنید تنها پروتکل های trojan,vless,vmess مورد تایید می باشند", 'reply_markup' => $backAdmin]);
            }
            break;
        case  "date":
        case  "traffic":
        case  "iplimit":
        case  "price":
        case  "rowid":
            if (!ctype_digit($text)) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا! مقدار وارد شده باید بصورت عددی لاتین و بزرگتر از صفر وارد شود مانند: 35", 'reply_markup' => $backAdmin]);
            } else {
                $ok = true;
            }
            break;
    }
    if ($ok) {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت تغییر یافت.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
        $db->query("UPDATE `plan` SET `$explode[1]` = '$text' WHERE id = '$explode[2]'");
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
    }
}

// change service name - step 2
else if (strpos($step, 'changeName_') !== false) {
    $explode = explode('_', $step);
    if (preg_match('/^[a-zA-Z0-9_]+$/', $text)) {
        $selectConfig = $db->query("SELECT * FROM config WHERE code = '$text' AND user = '$from_id'")->fetch_assoc();
        if (!$selectConfig['code']) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ نام جدید با موفقیت ثبت شد. از این پس با استفاده از دستور زیر میتوانید اطلاعات سرویس خود را مشاهده کنید:\n\n/service_$text", 'reply_markup' => $home]);
            $db->multi_query("UPDATE user SET step = 'none';UPDATE config SET code = '$text' WHERE id = '$explode[1]'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا شما قبلا این نام را برای یکی از سرویس های خود استفاده کردید، لطفا نام دیگری وارد کنید", 'reply_markup' => $back]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا نام سرویس باید بصور اینگلیسی و بدون فاصله باشد مانند: myGermanServer", 'reply_markup' => $back]);
    }
}
// extend service traffice - step 2
else if (strpos($step, 'extendTraffic_') !== false) {
    $explode = explode('_', $step);
    if (is_numeric($text)) {
        $traffic =  (float) ($text);
        $price = (float) ($text) * $config->trafficPrice;
        $key = json_encode(['inline_keyboard' => [
            [['text' => "✅ تایید", 'callback_data' => "confirmExtend_$explode[1]_$traffic"], ['text' => "انصراف", 'callback_data' => 'back']],
        ]]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 افزایش $text گیگ به قیمت $price تومان در صورت تایید کلیک کنید", 'reply_markup' => $key, 'parse_mode' => 'html']);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا بصورت عدد لاتین وارد کنید مانند: 3000", 'reply_markup' => $back, 'parse_mode' => 'html']);
    }
} else if (strpos($step, 'useDiscount_') !== false) {
    $explode = explode('_', $step);
    $selectCode  = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$text'")->fetch_assoc();
    if ($selectCode['type']) {
        $_ =  explode('|', $selectCode['columnTwo']);

        if ($_[0] > $_[1]) {

            $selectServer = $db->query("SELECT servers.id FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '$explode[1]'")->fetch_assoc();
            $totalUsedTraffic = intval($db->query("SELECT SUM(traffic) FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id WHERE servers.id = '{$selectServer['id']}'")->fetch_assoc()['SUM(traffic)']);
            @$selectPlan = $db->query("SELECT plan.*,servers.max FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '$explode[1]'")->fetch_assoc();
            if ($totalUsedTraffic <= ($selectPlan['max'] + $selectPlan['traffic'])) {
                $ipLimit = $selectPlan['iplimit'] == 0 ? 'نامحدود' : "{$selectPlan['iplimit']} کاربر";
                $traffic = $selectPlan['traffic'] == 0 ? 'نامحدود' : "{$selectPlan['traffic']} گیگ";
                $dateExpire = $selectPlan['date'] == 0 ? 'نامحدود' : "{$selectPlan['date']} روز";
                $price = $selectPlan['price'];
                if ($user['cooperation'] == 1) {
                    $price = ($config->cooperationPrice * $price) / 100;
                }
                $newPrice = ((100 - $selectCode['columnOne']) / 100) * $price;
                $buyBtn = json_encode(['inline_keyboard' => [
                    [['text' => "💰 پرداخت با کیف پول", 'callback_data' => "buyPlan*{$explode[1]}*{$selectCode['type_id']}"]],
                    [['text' => "💎 پرداخت با درگاه ( IRR )", 'callback_data' => "payShaparak*{$explode[1]}*{$selectCode['type_id']}"], ['text' => "💳 کارت به کارت", 'callback_data' => "payOffline*{$explode[1]}*{$selectCode['type_id']}"]],
                    [['text' => "🔙 بازگشت", 'callback_data' => "buyService"]]
                ]]);
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🌟 کد تخفیف وارد شده صحیح می باشد!\n\n🎁 قیمت سرویس به میزان {$selectCode['columnOne']} درصد کاهش یافت\n————\n🔖 {$selectPlan['name']}\n\n💳 قیمت: <s>$price</s> تومان 👈 $newPrice تومان\n📋 تعداد اتصال: $ipLimit\n🔗 پروتکل: {$selectPlan['protocol']}\n📆 مدت زمان اعتبار:  $dateExpire\n💎 حجم: $traffic\n\n👇  در صورتی که تمایل به دریافت این سرویس دارید، با زدن دکمه زیر میتوانید از طریق کیف پول خود در ربات، پرداخت کنید.\n‌", 'parse_mode' => "html", 'reply_markup' => $buyBtn]);
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
            } else {
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");

                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ ظرفیت خرید از این سرور پر شده است لطفا سرور دیگری را انتخاب کنید.", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ ظرفیت استفاده از این کد تخفیف پر شده است", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کد تخفیف وارد شده صحیح نمی باشد.", 'reply_markup' => $back, 'parse_mode' => 'html']);
    }
}




//  ---- Handling Data ----

// see services information
if (strpos($data, 'manageService_') !== false || (preg_match('/^(\/service_)(.*)/', $text))) {

    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "⌛️"]);
    $explode = explode('_', $data ? $data : $text);
    $selectConfig = $db->query("SELECT config.*,plan.traffic,plan.protocol,plan.iplimit,plan.domain,plan.name FROM config JOIN plan ON config.planid = plan.id WHERE config.code = '$explode[1]'")->fetch_assoc();


    if ($selectConfig['id']) {
        $selectServer = $db->query("SELECT servers.* FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id WHERE config.code = '$explode[1]'")->fetch_assoc();
        $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        $result = $xui->list(['id' => (int)$selectConfig['inboundid']])[0];
        if ($result['id']) {
            if (count($result['clientStats']) == 1) {
                $totalTr = $result['total'];
                $upTr =  $result['up'];
                $down =  $result['down'];
                $status =  $result['enable'];
            } else {
                $clientStats = $result["clientStats"];
                $clients =  json_decode($result['settings'], true)['clients'];
                $cIndex = $xui->getClientStatsIndexByEmail($clientStats, $selectConfig['clientid']);
                if (!$cIndex) {
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ دسترسی به سرویس شما امکان پذیر نیست، لطفا به پشتیبانی اطلاع دهید.", 'reply_markup' => $home]);
                    exit();
                }
                $client = $clientStats[$cIndex];
                $totalTr =  $client['total'];
                $upTr =  $client['up'];
                $down =  $client['down'];
                $status =  $client['enable'];
            }
            $expireDate = strtotime($selectConfig['expire']) - strtotime(date('Y/m/d H:i', time()));
            if ($expireDate > 0) {
                $exp = $MahdyarEn->getTime($expireDate);
            } else {
                $exp = '💢 نیازمند تمدید';
            }
            $persianExpire = jdate("Y/m/d", strtotime($selectConfig['expire']));
            $key = [
                [['text' => "🔗 پروتکل: {$selectConfig['protocol']}", 'callback_data' => 'n']],
                [['text' => "ℹ️ تغییر نام سرویس", 'callback_data' => "changeName_{$selectConfig['id']}"]],
                [['text' => "🔖 تاریخ تمدید", 'callback_data' => 'n'], ['text' => "📅 تعداد روز باقی مانده", 'callback_data' => 'n']],
                [['text' => $persianExpire, 'callback_data' => 'n'], ['text' => $exp, 'callback_data' => 'n']],
                [['text' => "💎 نمایش حجم سرویس", 'callback_data' => "remain_{$selectConfig['id']}"], ['text' => "📋 حداکثر تعداد اتصال: {$selectConfig['iplimit']}", 'callback_data' => 'n']],
                [['text' => "♻️ تغییر لوکیشن سرویس", 'callback_data' => "changeLocation_{$selectConfig['id']}"], ['text' => "🔗 تغییر لینک اتصال", 'callback_data' => "changeLink_{$selectConfig['id']}"]],
                [['text' => "🌟 افزایش حجم سرویس", 'callback_data' => "extendTraffic_{$selectConfig['id']}"]],
            ];
            if (time() >= strtotime("{$selectConfig['expire']} -1 days") && $selectConfig['name'] != 'testService') {
                $key[] = [['text' => "🔖 تمدید زمان سرویس", 'callback_data' => "tamdidDate_{$selectConfig['id']}"]];
            }
            if (strpos($data, 'manageService_') !== false) $key[] = [['text' => "🔙 بازگشت", 'callback_data' => 'myServices']];
            $key = json_encode(['inline_keyboard' => $key]);

            $link = $MahdyarEn->getConfigLink($selectConfig["link"], $selectConfig['protocol'], $url[0], $selectConfig['domain'], $selectServer['host'],  $selectServer['tunnel']);
            $qrCode = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=" . urlencode($link);

            $status = $status ? '🟢 فعال' : '🔴 غیرفعال';
            if ($totalTr - $upTr - $down == 0  && $totalTr != 0) $status = '⭕️ اتمام حجم';
            $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $qrCode, 'caption' => "اطلاعات کانفیگ خریداری شما به شرح زیر می باشد 👇:\n\nوضعیت سرویس: $status\nپرتکل: {$selectConfig['protocol']}\n\n🔖 کد سرویس: <code>{$selectConfig['remark']}</code>\n🌟 نام سرویس: <code>{$selectConfig['code']}</code>\n\n<code>$link</code>\n‌", 'reply_markup' => $key, 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ دسترسی به سرویس شما امکان پذیر نیست، لطفا به پشتیبانی اطلاع دهید.", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ سرویس مورد نظر شما وجود ندارد.", 'reply_markup' => $home]);
    }
} elseif (strpos($data, 'payTrue_') !== false) {
    $explode = explode('_', $data);
    $selectFactor = $db->query("SELECT * FROM pay WHERE factor = '$explode[2]'")->fetch_assoc();
    $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "✅ پرداخت شما با شماره {$explode[2]} با موفقیت تایید شد و موجودی شما به مقدار {$selectFactor['amount']} تومان افزایش یافت."]);
    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "✅ پرداخت با شماره {$explode[2]} با موفقیت تایید شد و موجودی کاربر <a href='tg://user?id=$explode[1]'>$explode[1]</a> به مقدار {$selectFactor['amount']} تومان افزایش یافت.", 'parse_mode' => 'html']);
    $db->multi_query("UPDATE user SET stock = stock+{$selectFactor['amount']} WHERE id = '$explode[1]';UPDATE pay SET stats = 1 WHERE `factor` = '$explode[2]';");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "پرداخت تایید شد", 'callback_data' => "n"]],]])]);
    if ($explode[3]) {
        $MahdyarEn->editMessageText(['chat_id' => $explode[4], 'message_id' => $explode[3], 'text' => "👇 فاکتور شما تایید شد در صورت تمایل میتوانید سرویس خود را ایجاد کنید:"]);
    }
} elseif (strpos($data, 'payFalse_') !== false) {
    $explode = explode('_', $data);
    $msgId = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "⭕️ لطفا علت رد شدن فاکتور ارسالی را بر روی همین پیام ریپلای کنید.", 'parse_mode' => 'html'])['result']['message_id'];
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "پرداخت لغو شد", 'callback_data' => "n"]],]])]);
    $db->query("UPDATE user SET step = 'payAnswere|{$explode[1]}|{$explode[2]}|$msgId' WHERE id = '$from_id'");
}



// select plan to buy
elseif (strpos($data, 'seeTariff_') !== false) {
    $explode = explode('_', $data);
    @$selectPlans = $db->query("SELECT * FROM plan WHERE serverid = '$explode[1]' AND NOT `name` = 'testService' AND changed = 0");
    if ($selectPlans->num_rows > 0) {

        $key[] = [['text' => 'قیمت', 'callback_data' => "n"], ['text' => 'نام پلن', 'callback_data' => "n"]];
        while ($row = $selectPlans->fetch_assoc()) {
            $key[] = [['text' => number_format($row['price']) . ' تومان', 'callback_data' => "n"], ['text' => $row['name'], 'callback_data' => "n"]];
        }
        $key[] = [['text' => "بازگشت 🔙", 'callback_data' => "tariff"]];

        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "لیست قیمت های سرور انتخاب شده به شرح زیر می باشد",  'reply_markup' => json_encode(['inline_keyboard' => $key])]);
    } else {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "دسته بندی برای این سرور وجود ندارد", 'show_alert' => false]);
    }
}

// select plan to buy
elseif (strpos($data, 'buy_') !== false) {
    $explode = explode('_', $data);
    @$selectPlans = $db->query("SELECT * FROM plan WHERE serverid = '$explode[1]' AND NOT `name` = 'testService' AND changed = 0");
    if ($selectPlans->num_rows > 0) {

        while ($row = $selectPlans->fetch_assoc()) {
            $row2 = $selectPlans->fetch_assoc();
            if ($row2) {
                $key[] = [['text' => $row['name'], 'callback_data' => "buyThis_{$row['id']}_$explode[1]"], ['text' => $row2['name'], 'callback_data' => "buyThis_{$row2['id']}_$explode[1]"]];
            } else {
                $key[] = [['text' => $row['name'], 'callback_data' => "buyThis_{$row['id']}_$explode[1]"]];
            }
        }
        $key[] = [['text' => "بازگشت 🔙", 'callback_data' => "buyService"]];

        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "👇 لطفا یکی از پلن های زیر را انتخاب کنید",  'reply_markup' => json_encode(['inline_keyboard' => $key])]);
    } else {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "دسته بندی برای این سرور وجود ندارد", 'show_alert' => false]);
    }
}

// confirm plan
elseif (strpos($data, 'buyThis_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "⌛️"]);
    $selectServer = $db->query("SELECT servers.id FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '$explode[1]'")->fetch_assoc();
    $totalUsedTraffic = intval($db->query("SELECT SUM(traffic) FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id WHERE servers.id = '{$selectServer['id']}'")->fetch_assoc()['SUM(traffic)']);
    @$selectPlan = $db->query("SELECT plan.*,servers.max FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '$explode[1]'")->fetch_assoc();
    if ($totalUsedTraffic <= ($selectPlan['max'] + $selectPlan['traffic'])) {
        $ipLimit = $selectPlan['iplimit'] == 0 ? 'نامحدود' : "{$selectPlan['iplimit']} کاربر";
        $traffic = $selectPlan['traffic'] == 0 ? 'نامحدود' : "{$selectPlan['traffic']} گیگ";
        $dateExpire = $selectPlan['date'] == 0 ? 'نامحدود' : "{$selectPlan['date']} روز";
        $price = $selectPlan['price'];
        if ($user['cooperation'] == 1) {
            $price = ($config->cooperationPrice * $price) / 100;
        }
        $buyBtn = json_encode(['inline_keyboard' => [
            [['text' => "💰 پرداخت با کیف پول", 'callback_data' => "buyPlan*{$explode[1]}"]],
            [['text' => "💎 پرداخت با درگاه ( IRR )", 'callback_data' => "payShaparak*{$explode[1]}"], ['text' => "💳 کارت به کارت", 'callback_data' => "payOffline*{$explode[1]}"]],
            [['text' => "🎁 استفاده از کد تخفیف", 'callback_data' => "useDiscount_{$explode[1]}"]],
            [['text' => "🔙 بازگشت", 'callback_data' => "buy_{$explode[2]}"]]

        ]]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🔖 {$selectPlan['name']}\n\n💳 قیمت: $price تومان\n📋 تعداد اتصال: $ipLimit\n🔗 پروتکل: {$selectPlan['protocol']}\n📆 مدت زمان اعتبار:  $dateExpire\n💎 حجم: $traffic\n\n👇  در صورتی که تمایل به دریافت این سرویس دارید، با زدن دکمه زیر میتوانید از طریق کیف پول خود در ربات، پرداخت کنید.\n‌",  'reply_markup' => $buyBtn]);
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ ظرفیت خرید از این سرور پر شده است لطفا سرور دیگری را انتخاب کنید.", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
    }
} elseif (strpos($data, 'payShaparak*') !== false) {
    $explode = explode('*', $data);
    @$selectPlan = $db->query("SELECT * FROM plan WHERE id = '$explode[1]'")->fetch_assoc();
    $price = $selectPlan['price'];
    if ($explode[2]) {
        $selectCode  = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$explode[2]'")->fetch_assoc();
        $price = ((100 - $selectCode['columnOne']) / 100) * $price;
    }
    if ($user['cooperation'] == 1) {
        $price = ($config->cooperationPrice * $price) / 100;
    }
    $factor_number = uniqid();
    $zarinPal = $db->query("SELECT * FROM settings WHERE `type` = 'zarinpal'")->fetch_assoc();
    $nextPay = $db->query("SELECT * FROM settings WHERE `type` = 'nexpay'")->fetch_assoc();
    $idPay = $db->query("SELECT * FROM settings WHERE `type` = 'idpay'")->fetch_assoc();
    $zibal = $db->query("SELECT * FROM settings WHERE `type` = 'zibal'")->fetch_assoc();
    $pay_keyboard = [];
    if ($zarinPal['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با زرین پال", 'url' => Config::HOST_URL . "/pay/pay.php?type=zarinpal&factor=$factor_number"]];
    if ($nextPay['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با نکست پی", 'url' => Config::HOST_URL . "/pay/pay.php?type=nexpay&factor=$factor_number"]];
    if ($idPay['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با آیدی پی", 'url' => Config::HOST_URL . "/pay/pay.php?type=idpay&factor=$factor_number"]];
    if ($zibal['type_id'] == '✅') $pay_keyboard[] =  [['text' => "🔗 پرداخت با زیبال", 'url' => Config::HOST_URL . "/pay/pay.php?type=zibal&factor=$factor_number"]];
    if (count($pay_keyboard) == 0) {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "⭕️ درحال حاضر درگاه فعالی وجود ندارد، لطفا بعدا اقدام به پرداخت کنید و یا از سایر روش های پرداخت استفاده کنید.", 'show_alert' => true]);
    } else {
        $pay_keyboard[] = [['text' => "✅ تایید سفارش", 'callback_data' => "verifyPay*{$explode[1]}*{$explode[2]}*$factor_number"]];
        $pay_keyboard  = json_encode(['inline_keyboard' => $pay_keyboard]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ $price تومان با #موفقیت صادر گردید.\n\n📂 شماره فاکتور: <code>$factor_number</code>\n\n⏳ فاکتور صادر شده تنها 30 دقیقه اعتبار دارد.\n\nدرصورت #تایید پرداخت کنید 👇\n\n🌟 پس از پرداخت فاکتور، جهت ساخت سرویس مورد نظر شما بر روی دکمه «✅ تایید سفارش» کلیک کنید", 'parse_mode' => 'html', 'reply_markup' => $pay_keyboard]);
        $expire = time() + 1800;
        $db->query("INSERT into pay(id,amount,factor,`time`) VALUES('$from_id','$price','$factor_number','$expire')");
        $db->query("UPDATE user SET step = 'none'  WHERE id = '$from_id'");
    }
} elseif (strpos($data, 'payOffline*') !== false) {
    $explode = explode('*', $data);
    $payOffline = $db->query("SELECT * FROM settings WHERE `type` = 'payOffline'")->fetch_assoc();
    if ($payOffline['type_id'] == '✅') {
        $factor_number = uniqid();
        @$selectPlan = $db->query("SELECT * FROM plan WHERE id = '$explode[1]'")->fetch_assoc();
        $price = $selectPlan['price'];
        if ($explode[2]) {
            $selectCode  = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$explode[2]'")->fetch_assoc();
            $price = ((100 - $selectCode['columnOne']) / 100) * $price;
        }
        if ($user['cooperation'] == 1) {
            $price = ($config->cooperationPrice * $price) / 100;
        }
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ $price تومان با #موفقیت صادر گردید.\n\n📂 شماره فاکتور: <code>$factor_number</code>\n\nشماره کارت: " . Config::CARD_NUMBER . "\nبه نام: " . Config::CARD_NAME . "\nپس از پرداخت فیش را همینجا ارسال کنید 👇", 'reply_markup' => $back, 'parse_mode' => 'html']);
        $db->query("UPDATE user SET step = 'sendFish_{$chat_id}_{$factor_number}_{$explode[1]}_{$explode[2]}'  WHERE id = '$from_id'");
        $expire = time() + 9000000;
        $db->query("INSERT into pay(id,amount,factor,`time`) VALUES('$from_id','$price','$factor_number','$expire')");
    } else {
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "⭕️ درحال حاضر امکان کارت به کارت فراهم نمی باشد، لطفا از سایر روش های پرداخت استفاده کنید", 'show_alert' => true]);
    }
}





// making config for user
elseif (strpos($data, 'buyPlan*') !== false || strpos($data, 'verifyPay*') !== false) {
    $explode = explode('*', $data);
    if (strpos($data, 'verifyPay*') !== false) {
        @$selectFactor = $db->query("SELECT * FROM pay WHERE `factor` = '$explode[3]'")->fetch_assoc();
        if (!$selectFactor['stats']) {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "فاکتور مربوطه هنوز پرداخت نشده است", 'show_alert' => true]);
            exit();
        }
    }
    @$selectPlan = $db->query("SELECT * FROM plan WHERE id = '$explode[1]'")->fetch_assoc();
    $price = $selectPlan['price'];
    if ($explode[2]) {
        $selectCode  = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$explode[2]'")->fetch_assoc();
        $price = ((100 - $selectCode['columnOne']) / 100) * $price;
        $_ =  explode('|', $selectCode['columnTwo']);
        $_[1] += 1;
        $db->query("UPDATE settings SET columnTwo = '{$_[0]}|{$_[1]}' WHERE `type` = 'discount' AND `type_id` = '$explode[2]'");
    }
    if ($user['cooperation'] == 1) {
        $price = ($config->cooperationPrice * $price) / 100;
    }
    if ($price <= $stock) {
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "⌛️ درحال ساخت کانکشن شما لطفا صبور باشید..."]);
        $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$selectPlan['serverid']}'")->fetch_assoc();
        // config information
        $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
        $expireD = date('Y/m/d H:i', strtotime("+{$selectPlan['date']} days"));
        $expire = strtotime($expireD) * 1000;
        $startD = date('Y/m/d H:i');
        //    connect to xui panel api
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        // $random = $MahdyarEn->random() . $from_id . "@gmail.com";
        $randId = rand(10000, 90000);
        $random = $randId . "-" . $selectServer['remark'] . "@gmail.com";
        $remark =  $randId . "-" . $selectServer['remark'];

        if ($selectPlan['rowid'] != 0) {
            $add = $xui->addClientToInbound($selectPlan['rowid'], $selectPlan['traffic'] * 1024 * 1024 * 1024, $selectPlan['protocol'], $remark, $random, $expire, '', $selectPlan['iplimit'], $selectServer['host']);
        } else {
            $add = $xui->addInbound($selectPlan['traffic'] * 1024 * 1024 * 1024, 0, 0, true, $remark, null, $selectPlan['protocol'], $expire, $selectPlan['iplimit'], $selectPlan['network'], $selectPlan['security'], $selectPlan['domain'], $selectServer['host']);
        }
        if ($add["success"] == true) {
            // GET qrcode of congif
            $code = $MahdyarEn->random();
            $link = $MahdyarEn->getConfigLink($add["link"], $selectPlan['protocol'], $url[0], $selectPlan['domain'], $selectServer['host'],  $selectServer['tunnel']);
            $qrCode = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=" . urlencode($link);

            $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $qrCode, 'caption' => "✅ کانفیک شما با موفقیت ساخته شد.\n\n🔗 <code>$link</code>\n\n🔖 کد سرویس: <code>$remark</code>\n🌟 از این پس با استفاده از دستور زیر میتوانید سریع تر سرویس خود را مدیریت کنید:\n/service_$code\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "مدیریت سرویس", 'callback_data' => "manageService_$code"]]]])]);
            $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "✅ کانکشنی از سرویس {$selectPlan['name']} و از پلن {$selectServer['name']} برای کاربر <a href='tg://user?id=$from_id'>$from_id</a> ساخته شد. \n\n🔖 کد سرویس: <code>$remark</code>\n\nلینک کانکشن: <code>$link</code>\n#ساخت", 'parse_mode' => 'html']);

            if ($selectPlan['rowid'] != 0) {
                $db->multi_query("INSERT INTO `config` (`user`, `planid`, `expire`, `link`,`inboundid`,`clientid`,`code`,`remark`,`start`) VALUES ('$chat_id', $explode[1], '$expireD', '{$add["link"]}', '{$selectPlan['rowid']}','$random','$code','$remark','$startD');UPDATE user SET stock = stock-$price WHERE id = '$chat_id'");
            } else {
                $db->multi_query("INSERT INTO `config` (`user`, `planid`, `expire`, `link`,`inboundid`,`code`,`remark`,`start`) VALUES ('$chat_id', $explode[1], '$expireD', '{$add["link"]}', '{$add["id"]}','$code','$remark','$startD');UPDATE user SET stock = stock-$price WHERE id = '$chat_id'");
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر مشکلی پیش آمده، لطفا بعدا دوباره امتحان کنید.", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "⭕️ موجودی شما کافی نمی باشد لطفا اقدام به افزایش موجودی خود کنید."]);
    }
} elseif (strpos($data, 'useDiscount_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "🎁 لطفا کد تخفیف خود را وارد کنید:", 'reply_markup' => $back]);
    $db->query("UPDATE user SET step = 'useDiscount_{$explode[1]}' WHERE id = '$from_id'");
}

// editing server details
elseif (strpos($data, 'setTunnel_') !== false) {
    $explode = explode('_', $data);
    @$selectServer = $db->query("SELECT * FROM servers WHERE id = '$explode[1]'")->fetch_assoc();
    $tunnel = $selectServer['tunnel'] == '0' ? 'تنظیم نشده است' : $selectServer['tunnel'];
    $db->query("UPDATE user SET step = 'tunnel~$explode[1]' WHERE `id` = '$from_id'");
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "👈 شما در حال تنظیم تانل برای سرور {$selectServer['name']} می باشید.\n\n🔖 مقدار کنونی: $tunnel\n آیپی و یا دامنه ی سرور را بدون http | https وارد کنید.\n\n⭕️ درصورتی که قصد حذف تانل دارید، 0 را وارد کنید\n‌",  'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
}

// editing server details
elseif (strpos($data, 'editServer_') !== false) {
    $explode = explode('_', $data);
    @$selectServer = $db->query("SELECT * FROM servers WHERE id = '$explode[1]'")->fetch_assoc();
    $edit_key = json_encode(['inline_keyboard' => [
        [['text' => "ویرایش نام سرور", 'callback_data' => "change_name_{$explode[1]}"]], [['text' => "ویرایش حداکثر حجم", 'callback_data' => "change_max_{$explode[1]}"]], [['text' => "ویرایش نام ریمارک", 'callback_data' => "change_remark_{$explode[1]}"]], [['text' => "ویرایش یوزرنیم", 'callback_data' => "change_username_{$explode[1]}"]], [['text' => "ویرایش پسورد", 'callback_data' => "change_password_{$explode[1]}"]], [['text' => "ویرایش لینک", 'callback_data' => "change_link_{$explode[1]}"]], [['text' => "ویرایش هاست", 'callback_data' => "change_host_{$explode[1]}"]], [['text' => "🔙 بازگشت", 'callback_data' => 'backAdmin']],
    ]]);
    $totalTraffic = intval($db->query("SELECT SUM(traffic) FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id WHERE servers.id = '$explode[1]' AND NOT plan.name = 'testService'")->fetch_assoc()['SUM(traffic)']);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "✏️ شما در حال ویرایش سرور با #آیدی {$selectServer['id']} می باشید. اطلاعات سرور به شرح زیر می باشد:\n\nنام سرور: {$selectServer['name']}\n🔢 حداکثر حجم: {$selectServer['max']}\n🗒 ریمارک: {$selectServer['remark']}\n🛠️ هاست: {$selectServer['host']}\n\n🔐 اطلاعات ورود:\n\n👈  یوزرنیم: <tg-spoiler>{$selectServer['username']}</tg-spoiler>\n👈 پسورد: <tg-spoiler>{$selectServer['password']}</tg-spoiler>\n🔗 آدرس پنل: {$selectServer['link']}\n\nحجم کانفیگ فروخته شده: $totalTraffic\n\n👇 برای ویرایش یکی گزینه های زیر را انتخاب کنید\n‌",  'parse_mode' => 'html', 'reply_markup' => $edit_key]);
}

// change server information
elseif (strpos($data, 'change_') !== false) {
    $explode = explode('_', $data);
    @$selectServer = $db->query("SELECT * FROM servers WHERE id = '$explode[1]'")->fetch_assoc();
    $db->query("UPDATE user SET step = 'change|$explode[1]|$explode[2]' WHERE `id` = '$from_id'");
    $name = "";
    switch ($explode[1]) {
        case  "name":
            $name = "نام سرور";
            break;
        case  "max":
            $name = "حداکثر حجم";
            break;
        case  "remark":
            $name = "ریمارک";
            break;
        case  "username":
            $name = "یوزرنیم سرور";
            break;
        case  "password":
            $name = "پسورد سرور";
            break;
        case  "link":
            $name = "لینک سرور";
            break;
        case  "host":
            $name = "هاست سرور";
            break;
    }
    $MahdyarEn->deleteMessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شما درحال ویرایش $name می باشید. لطفا مقدار جدید را وارد کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
}

// toggle server stats
elseif (strpos($data, 'toggleStats_') !== false) {
    $explode = explode('_', $data);
    $stats = '';

    @$select =  $db->query("SELECT * FROM servers WHERE id = '$explode[1]'")->fetch_assoc();
    switch ($select['stats']) {
        case '✅':
            $stats = '❌';
            break;
        case '❌':
            $stats = '✅';
            break;
    }

    @$selectServers = $db->query("SELECT * FROM servers");
    $button[] = [['text' => "وضعیت نمایش", 'callback_data' => 'n'], ['text' => "حذف", 'callback_data' => 'n'], ['text' => "ویرایش", 'callback_data' => 'n'], ['text' => "حجم 🔢", 'callback_data' => 'n'], ['text' => "نام ℹ️", 'callback_data' => 'n']];

    while ($row = $selectServers->fetch_assoc()) {
        if ($row['id'] == $explode[1]) {
            $button[] = [['text' => $stats, 'callback_data' => "toggleStats_{$row['id']}"], ['text' => "❌", 'callback_data' => "removeServer_{$row['id']}"], ['text' => "✏️", 'callback_data' => "editServer_{$row['id']}"], ['text' => $row['max'], 'callback_data' => 'n'], ['text' => $row['name'], 'callback_data' => 'n']];
        } else {
            $button[] = [['text' => $row['stats'], 'callback_data' => "toggleStats_{$row['id']}"], ['text' => "❌", 'callback_data' => "removeServer_{$row['id']}"], ['text' => "✏️", 'callback_data' => "editServer_{$row['id']}"], ['text' => $row['max'], 'callback_data' => 'n'], ['text' => $row['name'], 'callback_data' => 'n']];
        }
    }

    $db->query("UPDATE servers SET stats = '$stats' WHERE id = '$explode[1]'");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
}

// remove server
elseif (strpos($data, 'removeServer_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "‼️ آیا از حذف سرور اطمینان دارید؟ این عملیات غیرقابل بازگشت می باشد.\n\n⭕️ درصورت حذف سرور تمامی پلن ها و کانفیگ های مربوط به این سرور بطور کامل از دیتابیس حذف خواهند شد.\n‌", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "imsure_$explode[1]"], ['text' =>  "خیر", 'callback_data' => "noimnot"]]]])]);
}

// confirm removing
elseif (strpos($data, 'imsure_') !== false) {
    $explode = explode('_', $data);
    $db->multi_query("DELETE FROM servers WHERE id = '$explode[1]';UPDATE user SET step = 'none' WHERE id = '$from_id'");
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "✅ سرور مورد نظر شما با موفقیت حذف شد", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
}

// remove lock Channel
elseif (strpos($data, 'removeCh_') !== false) {
    $explode = explode('_', $data);
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
    $db->query("DELETE FROM settings WHERE `type` = 'channel' AND `type_id` = '$explode[1]'");
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👌 کانال مورد نظر از لیست جوین اجباری حذف شد", 'parse_mode' => "html", 'reply_markup' => $admin]);
}
// 
elseif (strpos($data, 'setSrvPlan_') !== false) {
    $select = explode('_', $data);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ سرور با موفقیت انتخاب شد.\nلطفا نام پلن را وارد کنید:\n", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
    $db->multi_query("UPDATE user SET step = 'addPlan2' WHERE id = '$from_id';UPDATE settings SET type_id = '$select[1]' WHERE `type` = 'plan'");
} elseif (strpos($data, 'setTestPlan_') !== false) {
    $select = explode('_', $data);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ سرور با موفقیت انتخاب شد.\n\nلطفا مشخصات سرویس را بصورت زیر وارد کنید:\n<code>vless-30-200-3-ws-tls|domain.com</code>\n🏷 توضیحات:\nمقدار اول (vless) : نوع پروتکل می باشد (تنها پروتکل های vmess-vless-trojan مورد پذیرش میباشد)\nمقدار دوم (30) : تعداد روز های اعتبار کانکشن (0 برای نامحدود بودن)\nمقدار سوم (200) : حجم کانفیگ ساخته شده به <b><i><u> مگابایت</u></i></b>\nمقدار چهارم (3) : چند کاربره بودن کانکشن (0 برای نامحدود)\nمقدار پنجم (ws) : نوع انتقال شبکه تنها ws tcp grpc مجاز می باشد\nمقدار ششم (tls|domain.com) : نوع امنیت شبکه - در صورت وارد کردن xtls و یا tls دامنه را با علامت | جدا کنید. در صورتیکه نمیخواهید استفاده کنید مقدار none را بگذارید\n\n💎 درصورتی که قصد دارید روی یک پورت چند کلاینت ایجاد کنید مثل زیر عمل کنید:\n\n<code>vless-1-200-3-1</code>\n🏷 توضیحات:\nمقدار اول (vless) : نوع پروتکل می باشد (تنها پروتکل های vmess-vless مورد پذیرش میباشد)\nمقدار دوم (1) : تعداد روز های اعتبار کانکشن (0 برای نامحدود بودن)\nمقدار سوم (200) : حجم کانفیگ ساخته شده به <b><i><u> مگابایت</u></i></b>\nمقدار چهارم (3) : چند کاربره بودن کانکشن (0 برای نامحدود\nمقدار پنجم (1): آیدی کانکشن در پنل xui\n‌", 'reply_markup' => $backAdmin, 'parse_mode' => 'html']);
    $db->multi_query("UPDATE user SET step = 'addTestPlan2' WHERE id = '$from_id';UPDATE settings SET type_id = '$select[1]' WHERE `type` = 'plan'");
}



// editing plan details
elseif (strpos($data, 'servicePage_') !== false) {
    $explode = explode('_', $data);
    $offset  = ($explode[1] - 1) * 10;
    $page = $explode[1] + 1;
    $page1 = $explode[1] - 1;
    $configCount = $db->query("SELECT id FROM config WHERE user = '$chat_id'")->num_rows;
    $userConfig = $db->query("SELECT * FROM config WHERE user = '$chat_id' LIMIT 10 OFFSET $offset");
    while ($row = $userConfig->fetch_assoc()) {
        @$selectServer = $db->query("SELECT servers.name FROM servers JOIN plan ON plan.serverid = servers.id WHERE plan.id = '{$row['planid']}' ")->fetch_assoc();
        $button[] = [['text' => $selectServer["name"] . " - " . $row['code'], 'callback_data' => "manageService_{$row['code']}"]];
    }
    $test = checkPage(1, $configCount - 1, 10);
    if (checkPage(1, $configCount - 1, 10) + 1 != $page and $page1 != 0) {
        $button[] = [['text' => "👉", 'callback_data' => "servicePage_{$page}"], ['text' => "👈", 'callback_data' => "servicePage_{$page1}"]];
    } else {
        if (checkPage(1, $configCount - 1, 10) < $page) {
            $button[] = [['text' => "👈", 'callback_data' => "servicePage_{$page1}"]];
        } else {
            if ($page > 0) {
                $button[] = [['text' => "👉", 'callback_data' => "servicePage_{$page}"]];
            }
        }
    }
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
}

// editing plan details
elseif (strpos($data, 'planPage_') !== false) {
    $explode = explode('_', $data);
    $offset  = ($explode[1] - 1) * 19;
    $page = $explode[1] + 1;
    $page1 = $explode[1] - 1;
    $planCount = $db->query("SELECT id FROM plan WHERE changed = 0")->num_rows;
    @$selectPlan = $db->query("SELECT * FROM plan WHERE changed = 0 LIMIT 19 OFFSET $offset");
    $button[] = [['text' => "حذف", 'callback_data' => 'n'], ['text' => "ویرایش", 'callback_data' => 'n'], ['text' => "🌐 سرور", 'callback_data' => 'n'], ['text' => "نام ℹ️", 'callback_data' => 'n']];
    while ($row = $selectPlan->fetch_assoc()) {
        $selectServer = $db->query("SELECT servers.name FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$row['id']}'")->fetch_assoc();
        $button[] = [['text' => "❌", 'callback_data' => "removePlan_{$row['id']}"], ['text' => "✏️", 'callback_data' => "editPlan_{$row['id']}"], ['text' => $selectServer['name'], 'callback_data' => 'n'], ['text' => $row['name'], 'callback_data' => 'n']];
    }
    if (checkPage(4, $planCount) + 1 != $page and $page1 != 0) {
        $button[] = [['text' => "👉", 'callback_data' => "planPage_{$page}"], ['text' => "👈", 'callback_data' => "planPage_{$page1}"]];
    } else {
        if (checkPage(4, $planCount) < $page) {
            $button[] = [['text' => "👈", 'callback_data' => "planPage_{$page1}"]];
        } else {
            if ($page > 0) {
                $button[] = [['text' => "👉", 'callback_data' => "planPage_{$page}"]];
            }
        }
    }
    // $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت تغییر یافت.", 'parse_mode' => 'html', 'reply_markup' => $admin]);

    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
}

// editing plan details
elseif (strpos($data, 'editPlan_') !== false) {
    $explode = explode('_', $data);
    @$selectPlan = $db->query("SELECT * FROM plan WHERE id = '$explode[1]'")->fetch_assoc();
    @$selectServer = $db->query("SELECT * FROM servers WHERE id = '{$selectPlan['serverid']}'")->fetch_assoc();
    $planDomain = $selectPlan['domain'] ? $selectPlan['domain'] : 'تنظیم نشده است';
    $planType = $selectPlan['rowid'] ? "🌟 ایجاد کلاینت روی یک پورت\n📍آیدی کانکشن در پنل: {$selectPlan['rowid']}" : '🌟 ایجاد کانفیگ روی پورت رندوم';

    $edit_key =    [
        [['text' => "ویرایش نام", 'callback_data' => "changePlan_name_{$explode[1]}"]], [['text' => "ویرایش پروتکل پلن", 'callback_data' => "changePlan_protocol_{$explode[1]}"]], [['text' => "ویرایش تاریخ انقضا", 'callback_data' => "changePlan_date_{$explode[1]}"]], [['text' => "ویرایش حجم", 'callback_data' => "changePlan_traffic_{$explode[1]}"]], [['text' => "ویرایش حداکثر اتصال", 'callback_data' => "changePlan_iplimit_{$explode[1]}"]], [['text' => "ویرایش قیمت", 'callback_data' => "changePlan_price_{$explode[1]}"]], [['text' => "ویرایش دامنه", 'callback_data' => "changePlan_domain_{$explode[1]}"]]
    ];
    if ($selectPlan['rowid']) {
        $edit_key[] = [['text' => "ویرایش آیدی کانکشن در پنل xui", 'callback_data' => "changePlan_rowid_{$explode[1]}"]];
    }
    $edit_key[] = [['text' => "🔙 بازگشت", 'callback_data' => 'managePlans']];
    $edit_key   = json_encode(['inline_keyboard' => $edit_key]);

    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "✏️ شما در حال ویرایش پلن با #آیدی {$selectPlan['id']} از سرور {$selectServer['name']} می باشید. اطلاعات پلن به شرح زیر می باشد:\n\n💎 نوع پلن: $planType\n\nنام پلن: {$selectPlan['name']}\n🔢 حجم پلن: {$selectPlan['traffic']}\n💎 پروتکل: {$selectPlan['protocol']}\n🗒 تاریخ انقضا: {$selectPlan['date']} روزه\n🔗 حداکثر اتصال: {$selectPlan['iplimit']}\n💰قیمت پلن: {$selectPlan['price']}\n\nدامنه پلن: $planDomain\n👇 برای ویرایش یکی گزینه های زیر را انتخاب کنید\n‌",  'parse_mode' => 'html', 'reply_markup' => $edit_key]);
}

// change plan information
elseif (strpos($data, 'changePlan_') !== false) {
    $explode = explode('_', $data);
    @$selectPlan = $db->query("SELECT * FROM plan WHERE id = '$explode[1]'")->fetch_assoc();
    $db->query("UPDATE user SET step = 'changePlan|$explode[1]|$explode[2]' WHERE `id` = '$from_id'");
    $name = "";
    switch ($explode[1]) {
        case  "name":
            $name = "نام پلن";
            break;
        case  "protocol":
            $name = "پروتکل پلن";
            break;
        case  "date":
            $name = "تاریخ انقضا";
            break;
        case  "traffic":
            $name = "حجم پلن";
            break;
        case  "iplimit":
            $name = "حداکثر اتصال پلن سرور";
            break;
        case  "price":
            $name = "قیمت پلن";
            break;
        case  "domain":
            $name = "دامنه پلن";
            break;
        case  "rowid":
            $name = "آیدی کانکشن";
            break;
    }
    $MahdyarEn->deleteMessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شما درحال ویرایش $name می باشید. لطفا مقدار جدید را وارد کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
}


// remove plan
elseif (strpos($data, 'removePlan_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "‼️ آیا از حذف پلن اطمینان دارید؟ این عملیات غیرقابل بازگشت می باشد.\n\n⭕️ درصورت حذف سرور تمامی  کانفیگ های مربوط به این پلن بطور کامل از دیتابیس حذف خواهند شد.\n‌", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "confrimPlan_$explode[1]"], ['text' =>  "خیر", 'callback_data' => "noimnot"]]]])]);
}
// confirm remove
elseif (strpos($data, 'confrimPlan_') !== false) {
    $explode = explode('_', $data);
    $db->multi_query("DELETE FROM plan WHERE id = '$explode[1]';UPDATE user SET step = 'none' WHERE id = '$from_id'");
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "✅ پلن مورد نظر شما با موفقیت حذف شد", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
}

// remove discount
elseif (strpos($data, 'removeDis~') !== false) {
    $explode = explode('~', $data);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "‼️ آیا از حذف کد تخفیف اطمینان دارید؟ این عملیات غیرقابل بازگشت می باشد\n‌", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "confrimDis~$explode[1]"], ['text' =>  "خیر", 'callback_data' => "noimnot"]]]])]);
}
// confirm remove
elseif (strpos($data, 'confrimDis~') !== false) {
    $explode = explode('~', $data);
    $db->multi_query("DELETE FROM settings WHERE `type` = 'discount'  AND `type_id` = '$explode[1]';UPDATE user SET step = 'none' WHERE id = '$from_id'");
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "✅ کد تخفیف مورد نظر شما با موفقیت حذف شد", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
}

// remove service
elseif (strpos($data, 'delService_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "‼️ آیا از حذف این سرویس کاربر اطمینان دارید؟ این عملیات غیرقابل بازگشت می باشد\n‌", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "confrimDelSrv_$explode[1]"], ['text' =>  "خیر", 'callback_data' => "noimnot"]]]])]);
}
// confirm remove user service from x-ui panel and bot db
elseif (strpos($data, 'confrimDelSrv_') !== false) {
    $explode = explode('_', $data);
    $select = $db->query("SELECT servers.link,servers.password,servers.username,config.id,plan.rowid,config.inboundid,config.clientid,config.user,config.remark FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    try {
        $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "⌛️"]);
        $xui = ConnectXui($select['link'], $select['username'], $select['password']);
        $result = $xui->removeInbound($select['inboundid'], $select['clientid']);
        if ($result['success']) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ سرویس متعلق به کاربر <a href='tg://user?id={$select['user']}'>{$select['user']}</a> بصورت کامل از سرور پاک شد.\n‌", 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "مشکلی هنگام حذف این کانفیگ از پنل xui پیش آمد. امکان دارد قبلا حذف شده باشد.", 'reply_markup' => $home]);
        }
        $db->query("DELETE FROM `config` WHERE id = '{$select['id']}' AND user = '{$select['user']}'");
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}


// unban user
elseif (strpos($data, 'unban_') !== false) {
    $match = explode('_', $data);
    $usz = $db->query("SELECT * FROM user WHERE id = '$match[1]'")->fetch_assoc();
    $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "کاربر مورد نظر با موفقیت آنبن شد", 'show_alert' => true]);
    $MahdyarEn->Sendmessage(['chat_id' => $usz['id'], 'text' => "✅ حساب شما با موفقیت باز شد، لطفا پیرو قوانین باشید", 'parse_mode' => "MarkDown"]);
    $db->query("UPDATE user SET ban = 0 WHERE `id` = '$match[1]'");
}

// see remain traffic from service
elseif (strpos($data, 'remain_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT plan.id,plan.rowid,config.inboundid,config.clientid FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    try {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال محاسبه حجم باقی مانده..."]);
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        $result = $xui->list(['id' => (int)$selectConfig['inboundid']])[0];
        if ($result['id']) {
            if ($selectConfig['rowid'] == 0) {
                $totalTr = $result['total'];
                $upTr =  $result['up'];
                $down =  $result['down'];
            } else {
                $clientStats = $result["clientStats"];
                $cIndex = $xui->getClientStatsIndexByEmail($clientStats, $selectConfig['clientid']);
                $client = $clientStats[$cIndex];
                $totalTr =  $client['total'];
                $upTr =  $client['up'];
                $down =  $client['down'];
            }
            $REMAIN = $totalTr - $upTr - $down;
            if ($totalTr == 0) {
                $totalTr = "نامحدود";
                $REMAIN = "نامحدود";
                $down = getSize($down);
                $upTr = getSize($upTr);
            } else {
                $REMAIN = getSize($REMAIN);
                $totalTr = getSize($totalTr);
                $down = getSize($down);
                $upTr = getSize($upTr);
            }
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 حجم باقی مانده سرویس شما به شرح زیر می باشد:\n\n💎 حجم کل سرویس: $totalTr\n\n📉 میزان دانلود: $down\n📈 میزان آپلود: $upTr\n\n🔖 حجم باقی مانده: $REMAIN\n‌", 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}

// see X-UI server details
elseif (strpos($data, 'seeStats_') !== false) {
    $explode = explode('_', $data);
    $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[1]}'")->fetch_assoc();
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال گرفتن اطلاعات سرور از پنل xui"]);
    try {
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        $result = $xui->status();
        if ($result['success'] == true) {
            $cpu = number_format($result['obj']['cpu'], 2);
            $usedMem = number_format($result['obj']['mem']['current'] / (1024 * 1024), 2);
            $totalMem = number_format($result['obj']['mem']['total'] / (1024 * 1024), 2);
            $usedDisk = number_format($result['obj']['disk']['current'] / (1024 * 1024 * 1024), 2);
            $totalDisk = number_format($result['obj']['disk']['total'] / (1024 * 1024 * 1024), 2);
            $xrayStatus = $result['obj']['xray']['state'] == 'running' ? 'درحال اجرا...' : $result['obj']['xray']['state'];
            $xrayV = $result['obj']['xray']['version'];
            $uptime = $MahdyarEn->getTime($result['obj']['uptime']);
            $leads =  $result['obj']['loads'];
            $tcpCount = $result['obj']['tcpCount'];
            $udpCount = $result['obj']['udpCount'];
            $netIOUp = number_format($result['obj']['netIO']['up'] / (1024), 2);
            $netIODown = number_format($result['obj']['netIO']['down'] / (1024), 2);
            $netTrafficSent = number_format($result['obj']['netTraffic']['sent'] / (1024 * 1024 * 1024), 2);
            $netTrafficRecv = number_format($result['obj']['netTraffic']['recv'] / (1024 * 1024 * 1024), 2);
            $key = json_encode(['inline_keyboard' => [
                [['text' => "🔗 ورود به پنل", 'url' => $selectServer['link']]],
                [['text' => "♻️ Restart Panel", 'callback_data' => "restartServer_{$explode[1]}"]],
                [['text' => "🛑 Stop Xray", 'callback_data' => "stopXray_{$explode[1]}"], ['text' => "♻️ Restart Xray", 'callback_data' => "restartXray_{$explode[1]}"]],
                [['text' => "📂 دریافت بکاپ", 'callback_data' => "backupServer_{$explode[1]}"]],
            ]]);

            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💎 <b>وضعیت پنل xui سرور مورد نظر شما به شرح زیر می باشد.</b>\n\n📈 <b>وضعیت کلی:</b>\n\n📍<b>مقدار cpu مصرفی:</b> <code>$cpu</code> درصد\n📍<b>حافظه:</b> <code>$usedMem MB</code> از <code>$totalMem MB</code>\n📍<b>هارد دیسک:</b> <code>$usedDisk GB</code> از <code>$totalDisk GB</code>\n\n📈 <b>پنل xui:</b>\n\n🌀 <b>وضعیت سرویس xray:</b> $xrayStatus\n📓 <b>ورژن پنل:</b> <code>$xrayV</code>\n〽️ <b>آپتایم:</b> $uptime\n\n❕ <b>لود سیستم:</b> $leads[2] | $leads[1] | $leads[0]\n❗️ <b>تعداد اتصالات:</b>  <code>tcp: $tcpCount</code> | <code>udp: $udpCount</code>\n\n📊 <b>وضعیت نتورک:</b>\n\n▫️ <b>سرعت آپلود کل برای تمام شبکه:</b>  <code>$netIOUp KB</code> \n▫️ <b>سرعت دانلود کل برای تمام شبکه:</b>  <code>$netIODown KB</code>\n\n\n▪️ <b>حجم دانلود شده کل:</b> <code>$netTrafficSent GB</code>\n▪️ <b>حجم آپلود شده کل:</b> <code>$netTrafficRecv GB</code>\n‌", 'reply_markup' => $key, 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده", 'reply_markup' => $admin]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'restartServer_') !== false) {
    $explode = explode('_', $data);
    $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[1]}'")->fetch_assoc();
    try {
        $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
        @$result = $xui->restartPanel();
        if ($result['success'] == true) {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "✅ پنل ریستارت شد", 'show_alert' => false]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده", 'reply_markup' => $admin]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'stopXray_') !== false) {
    $explode = explode('_', $data);
    $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[1]}'")->fetch_assoc();
    try {
        $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
        $result = $xui->stopXrayService();
        if ($result['success'] == true) {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "🛑 سرویس xray متوقف شد", 'show_alert' => false]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده", 'reply_markup' => $admin]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'restartXray_') !== false) {
    $explode = explode('_', $data);
    $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[1]}'")->fetch_assoc();
    try {
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
        $result = $xui->restartXrayService();
        if ($result['success'] == true) {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "✅ سرویس xray ریستارت شد", 'show_alert' => false]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده", 'reply_markup' => $admin]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'backupServer_') !== false) {

    $explode = explode('_', $data);
    $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "درحال بکاپ گیری از پنل xui...", 'show_alert' => false]);
    $selectServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[1]}'")->fetch_assoc();
    try {
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
        // Open a file handle to write the file
        @$result = $xui->getDb();
        if ($result) {
            $fh = fopen("x-ui.db", "w");
            fwrite($fh, $result);
            fclose($fh);
            $fileSize = getSize(filesize("x-ui.db"));
            $MahdyarEn->sendDocument(['chat_id' => $chat_id, 'document' => new CURLFile("x-ui.db"), 'caption' => "📂 <a href='{$selectServer['link']}'>بک‌آپ پنل xui</a>\n\n🔖 نام سرور: {$selectServer['name']}\n💾 حجم بک‌آپ: $fileSize\n🕒 $date | $time\n\n#بک‌آپ\n‌", 'parse_mode' => 'html']);
            @unlink("x-ui.db");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام بکاپ گیری پیش آمد", 'reply_markup' => $admin]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}


// tamdid plan
elseif (strpos($data, 'tamdidDate_') !== false) {
    $explode = explode('_', $data);
    $selectPlan = $db->query("SELECT config.expire,config.clientid,plan.id,config.expire,plan.traffic,plan.name,plan.iplimit,plan.date,plan.protocol,plan.price FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $ipLimit = $selectPlan['iplimit'] == 0 ? 'نامحدود' : "{$selectPlan['iplimit']} کاربر";
    $traffic = $selectPlan['traffic'] == 0 ? 'نامحدود' : "{$selectPlan['traffic']} گیگ";
    $dateExpire = $selectPlan['date'] == 0 ? 'نامحدود' : "{$selectPlan['date']} روز";
    $price = $selectPlan['price'];
    if ($user['cooperation'] == 1) {
        $price = ($config->cooperationPrice * $price) / 100;
    }
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "🌟 درصورتی که قصد تمدید سرویس با مشخصات زیر را دارید دکمه زیر را انتخاب کنید 👇\n🔖 {$selectPlan['name']}\n\n💳 قیمت: $price تومان\n📋 تعداد اتصال: $ipLimit\n🔗 پروتکل: {$selectPlan['protocol']}\n📆 مدت زمان اعتبار:  $dateExpire\n💎 حجم: $traffic\n\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "confirmTamdid_$explode[1]_{$selectPlan['id']}"], ['text' =>  "انصراف", 'callback_data' => "back"]]]])]);
}
// confirm tamdid
elseif (strpos($data, 'confirmTamdid_') !== false) {
    $explode = explode('_', $data);
    $selectPlan = $db->query("SELECT config.expire,config.clientid,config.inboundid,plan.id,plan.traffic,plan.name,plan.iplimit,plan.date,plan.price FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '$explode[2]'")->fetch_assoc();
    if ($selectPlan['price'] <= $stock) {
        $expire = strtotime("+{$selectPlan['date']} days", time()) * 1000;
        try {
            $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

            $update = $xui->resetTrafficAndExpire($selectPlan['inboundid'], $expire, $selectPlan['clientid']);
            $englishExpire =  date('Y/m/d H:i', strtotime("+{$selectPlan['date']} days"));
            $persianExpire =  jdate("Y/m/d", strtotime($englishExpire));
            if ($update['success'] == true) {
                $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "✅ سرویس شما با موفقیت تا تاریخ $persianExpire تمدید شد. ", 'parse_mode' => 'html', 'reply_markup' => $home]);
                $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "سرویس متعلق به کاربر <a href='tg://user?id=$from_id'>$from_id</a> تا تاریخ $persianExpire تمدید شد.\n#تمدید\n.", 'parse_mode' => 'html']);
                $db->multi_query("UPDATE config SET expire = '$englishExpire', say = 0 WHERE id = '$explode[1]';UPDATE user SET stock = stock-{$selectPlan['price']} WHERE id = '$chat_id'");
            } else {
                $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
            }
        } catch (Exception $e) {
            $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
        }
    } else {
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "⭕️ موجودی شما کافی نمی باشد لطفا اقدام به افزایش موجودی خود کنید."]);
    }
} elseif (strpos($data, 'changeLink_') !== false) {
    $explode = explode('_', $data);
    $key = json_encode(['inline_keyboard' => [[['text' => "✅ تغییر لینک", 'callback_data' => "confirmChangeLink_$explode[1]"], ['text' => "انصراف", 'callback_data' => 'back']],]]);
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "⭕️ برای تغییر لینک اتصال و قطع دسترسی دیگران، یکی از گزینه های زیر را انتخاب کنید", 'parse_mode' => 'html', 'reply_markup' => $key]);
} elseif (strpos($data, 'confirmChangeLink_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT plan.*,config.expire,config.remark,config.inboundid,config.clientid FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    try {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال تغییر لینک اتصال سرویس..."]);
        $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        $changeLink = $xui->changeLink($selectConfig['inboundid'], $selectConfig['remark'] ? $selectConfig['remark'] : 'none', $selectConfig['clientid'], $selectServer['host']);
        if ($changeLink['success'] == true && $changeLink['link']) {
            $link = $MahdyarEn->getConfigLink($changeLink['link'], $selectConfig['protocol'], $url[0], $selectConfig['domain'], $selectServer['host'], $selectServer['tunnel']);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ لینک سرویس شما با موفقیت تغییر یافت\n\n🔗 ادرس جدید اتصال:\n<code>$link</code>",  'parse_mode' => 'html', 'reply_markup' => $home]);
            $db->query("UPDATE config SET link = '{$changeLink['link']}' WHERE id = '$explode[1]'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}

// change service name - step 1
elseif (strpos($data, 'changeName_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT * FROM config WHERE id = '$explode[1]'")->fetch_assoc();
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "💎 نام فعلی سرویس شما: {$selectConfig['code']}\n👈 نام جدید سرویس خود را با حروف لاتین و بدون فاصله وارد کنید:\n‌", 'parse_mode' => 'html', 'reply_markup' => $back]);
    $db->query("UPDATE user SET step = 'changeName_$explode[1]' WHERE id = '$from_id'");
}


// see all user services
elseif (strpos($data, 'userServices_') !== false) {
    $explode = explode('_', $data);
    @$userConfig = $db->query("SELECT config.*,plan.traffic,plan.protocol,plan.iplimit,plan.domain FROM config JOIN plan ON config.planid = plan.id WHERE config.user = '$explode[1]'");
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️"]);
    if ($userConfig->num_rows == 0) {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کاربر انتخاب شده سرویسی ندارد", 'reply_markup' => $admin]);
    } else {

        while ($row = $userConfig->fetch_assoc()) {
            $expireDate = strtotime($row['expire']) - strtotime(date('Y/m/d H:i', time()));
            if ($expireDate > 0) {
                $exp = $MahdyarEn->getTime($expireDate);
            } else {
                $exp = '💢 نیازمند تمدید';
            }
            $persianExpire = jdate("Y/m/d", strtotime($row['expire']));
            $key = json_encode(['inline_keyboard' => [
                [['text' => "🔗 پروتکل: {$row['protocol']}", 'callback_data' => 'n']],
                [['text' => "🔖 تاریخ تمدید", 'callback_data' => 'n'], ['text' => "📅 تعداد روز باقی مانده", 'callback_data' => 'n']],
                [['text' => $persianExpire, 'callback_data' => 'n'], ['text' => $exp, 'callback_data' => 'n']],
                [['text' => "💎 نمایش حجم سرویس", 'callback_data' => "remain_{$row['id']}"], ['text' => "📋 حداکثر تعداد اتصال: {$row['iplimit']}", 'callback_data' => 'n']],
                [['text' => "⭕ حذف سرویس کاربر", 'callback_data' => "delService_{$row['id']}"]],
            ]]);
            $selectServer = $db->query("SELECT servers.link,servers.host,servers.tunnel FROM plan JOIN servers ON plan.serverid = servers.id  JOIN config ON config.planid = plan.id WHERE config.id = '{$row['id']}'")->fetch_assoc();
            $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
            $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
            $link = $MahdyarEn->getConfigLink($row["link"], $row['protocol'], $url[0], $row['domain'], $selectServer['host'],  $selectServer['tunnel']);
            $qrCode = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=" . urlencode($link);
            $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $qrCode, 'caption' => "اطلاعات کانفیگ کاربر مورد نظر شما به شرح زیر می باشد:\n\n🔖 کد سرویس: <code>{$row['remark']}</code>\n🌟 نام سرویس: <code>{$row['code']}</code>\n\n<code>$link</code>\n‌", 'reply_markup' => $key, 'parse_mode' => 'html']);
        }
    }
}



// extend service traffice - step 1
elseif (strpos($data, 'extendTraffic_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "👈 حجم دلخواه برای اضافه شدن به سرویس کنونی خود را وارد کنید\nقیمت هر گیگ ترافیک: {$config->trafficPrice} تومان", 'parse_mode' => 'html', 'reply_markup' => $back]);
    $db->query("UPDATE user SET step = 'extendTraffic_$explode[1]' WHERE id = '$from_id'");
}


// extend service traffice - step 3
elseif (strpos($data, 'confirmExtend_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT plan.*,config.expire,config.inboundid,config.clientid FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $price = $explode[2] * $config->trafficPrice;
    if ($stock >= $price) {
        try {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال افزایش ترافیک سرویس شما..."]);
            $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
            $result = $xui->increaseTraffic($selectConfig['inboundid'], $explode[2], $selectConfig['clientid']);
            if ($result['success'] == true) {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ حجم سرویس مورد نظر شما با موفقیت به میزان $explode[2] گیگ افزایش یافت", 'reply_markup' => $home]);
                $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "سرویس متعلق به کاربر <a href='tg://user?id=$from_id'>$from_id</a> به مقدار $explode[2] گیگ افزایش حجم یافت\n#افزایش_حجم\n.", 'parse_mode' => 'html']);
                $db->query("UPDATE user SET step = 'none', stock = stock-$price  WHERE id = '$from_id'");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
            }
        } catch (Exception $e) {
            $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ موجودی شما کافی نمی باشد لطفا اقدام به افزایش موجودی خود کنید.", 'reply_markup' => $home]);
    }
}

// change location of service
elseif (strpos($data, 'changeLocation_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT config.expire,plan.id,config.expire,plan.traffic,plan.name,plan.iplimit,plan.rowid FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT servers.name,servers.id FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    $allServers = $db->query("SELECT * FROM servers WHERE NOT id = '{$selectServer['id']}'")->fetch_assoc();
    if ($allServers) {
        if ($selectConfig['rowid'] == 0) {
            $expireDate = strtotime($selectConfig['expire']) - strtotime(date('Y/m/d H:i', time()));
            if ($expireDate > 0) {
                $exp = $MahdyarEn->getTime($expireDate);
            } else {
                $exp = '💢 نیازمند تمدید';
            }
            @$buttonServer = $db->query("SELECT * FROM servers WHERE NOT id = '{$selectServer['id']}'");
            while ($row = $buttonServer->fetch_assoc()) {
                $button[] = [['text' => "{$row['name']}", 'callback_data' => "changeLocation2_$explode[1]_{$row['id']}"]];
            }
            $button[] = [['text' => "🔙 بازگشت", 'callback_data' => 'back']];
            $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "🌟 کاربر گرامی به بخش تغییر لوکیشن سرویس خوش آمدید.\n\nاطلاعات سرویس شما:\n\n💎 حجم کل: {$selectConfig['traffic']} GB\n🔗 تعداد اتصال: {$selectConfig['iplimit']}\n📅 انقضا: $exp\n🏷 نام پلن: {$selectConfig['name']}\n🌍 سرویس: {$selectServer['name']}\n\n👇 برای تغییر لوکیشن، لطفا یکی از سرور های زیر را انتخاب کنید ", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['inline_keyboard' => $button])]);
        } else {
            $MahdyarEn->deleteSendMessage(['chat_id' => $from_id, 'message_id' => $message_id], ['chat_id' => $from_id, 'text' => "⭕️ امکان تغییر لوکیشن برای سرویس انتخابی شما وجود ندارد.", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر برای تغییر لوکیشن، سرویس دیگری وجود ندارد", 'reply_markup' => $home]);
    }
}

// change location of service - step 2
elseif (strpos($data, 'changeLocation2_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT plan.id,config.inboundid,config.expire FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال محاسبه حجم باقی مانده..."]);
    try {
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);
        $result = $xui->list(['id' => (int)$selectConfig['inboundid']])[0];
        if ($result['id']) {

            $totalTr = $result['total'];
            $upTr =  $result['up'];
            $down =  $result['down'];
            $REMAIN = $totalTr - $upTr - $down;
            if ($totalTr == 0) {
                $totalTr = "نامحدود";
                $REMAIN = "نامحدود";
                $show_down = getSize($down);
                $show_upTr = getSize($upTr);
            } else {
                $REMAIN = getSize($REMAIN);
                $totalTr = getSize($totalTr);
                $show_down = getSize($down);
                $show_upTr = getSize($upTr);
            }
            $confirm_change = json_encode(['inline_keyboard' => [
                [['text' => "✅ تایید و انتقال", 'callback_data' => "cofirmChange_$explode[1]_$explode[2]"]],
                [['text' => "❌ انصراف", 'callback_data' => 'back']],
            ]]);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 برای تغییر لوکیشن سرویس اطلاعات زیر را تایید کنید:

        \n\n💎 حجم کل سرویس: $totalTr\n\n📉 میزان دانلود: $show_upTr\n📈 میزان آپلود: $show_down\n\n🔖 حجم باقی مانده: $REMAIN
        
        ⭕️ درصورت تایید سرویس فعلی شما حذف و انتقال پیدا میکند.\n‌", 'parse_mode' => 'html', 'reply_markup' => $confirm_change]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}

// confirm changing location
elseif (strpos($data, 'cofirmChange_') !== false) {
    $explode = explode('_', $data);
    $selectConfig = $db->query("SELECT plan.*,config.expire,config.inboundid FROM config JOIN plan ON config.planid = plan.id WHERE config.id = '$explode[1]'")->fetch_assoc();
    $selectServer = $db->query("SELECT * FROM plan JOIN servers ON plan.serverid = servers.id WHERE plan.id = '{$selectConfig['id']}'")->fetch_assoc();
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    try {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال تغییر لوکیشن سرویس..."]);
        $expire = strtotime("{$selectConfig['expire']}") * 1000;
        $xui = ConnectXui($selectServer['link'], $selectServer['username'], $selectServer['password']);

        $result = $xui->list(['id' => (int)$selectConfig['inboundid']])[0];
        if ($result['id']) {
            $totalTr = $result['total'];
            $upTr =  $result['up'];
            $down =  $result['down'];
            $REMAIN = $totalTr - $upTr - $down;
            $xui->removeInbound($selectConfig['inboundid']);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال ایجاد سرویس جدید..."]);
            $selectNewServer = $db->query("SELECT * FROM servers WHERE id = '{$explode[2]}'")->fetch_assoc();
            $url = explode(':', str_replace(array("http://", "https://"), "", $selectNewServer['link']));
            $xui = ConnectXui($selectNewServer['link'], $selectNewServer['username'], $selectNewServer['password']);
            $remark =   rand(10000, 90000) . "-" . $selectNewServer['remark'];
            $add = $xui->addInbound($REMAIN, 0, 0, true, $remark, null, $selectConfig['protocol'], $result['expiryTime'], $selectConfig['iplimit'], $selectConfig['network'], $selectConfig['security'], $selectConfig['domain'], $selectNewServer['host']);
            if ($add["success"] == true) {
                if ($selectConfig['changed'] != 1) {
                    $db->query("INSERT INTO plan(`protocol`,`date`,`traffic`,`iplimit`,`serverid`,price,`name`,`changed`) VALUES('{$selectConfig['protocol']}','{$selectConfig['date']}','{$selectConfig['date']}','{$selectConfig['iplimit']}','{$selectNewServer['id']}','{$selectConfig['price']}','{$selectConfig['name']}',1)");
                    $planID = $db->insert_id;
                } else {
                    $db->query("UPDATE plan SET serverid = '{$selectNewServer['id']}' WHERE id = '{$selectConfig['id']}'");
                }
                // GET qrcode of congif
                $link = $MahdyarEn->getConfigLink($add["link"], $selectConfig['protocol'], $url[0], $selectConfig['domain'], $selectNewServer['host'],  $selectNewServer['tunnel']);
                $qrCode = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=" . urlencode($link);
                $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $qrCode, 'caption' => "✅ سرویس شما با موفقیت به {$selectNewServer['name']} تغییر یافت، اطلاعات کانکشن جدید شما:\n\n🔗 <code>$link</code>\n‌", 'parse_mode' => 'html', 'reply_markup' => $home]);
                $db->query("UPDATE config SET `inboundid` = '{$add["id"]}', `link` = '{$add["link"]}', `planid` = '$planID', `remark` = '$remark'  WHERE id = '$explode[1]'");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر مشکلی پیش آمده، لطفا بعدا دوباره امتحان کنید.", 'reply_markup' => $home]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطایی هنگام اتصال به سرور پیش آمده لطفا به پشتیبانی اطلاع دهید", 'reply_markup' => $home]);
        }
    } catch (Exception $e) {
        $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⚠️ گزارش خطا مربوط به کاربر ( <a href='tg://user?id=$from_id'>$from_id</a> ) :\n\n👈 متن خطا: {$e->getMessage()}\n👈 لاین مربوط به خطا: {$e->getLine()}\n\n#گزارش_خطا", 'parse_mode' => 'html']);
    }
}

// status of payment gateway
elseif (strpos($data, 'status_') !== false) {
    $explode = explode('_', $data);
    $payment = $db->query("SELECT * FROM settings WHERE `type` = '$explode[1]'")->fetch_assoc();
    $stats = '';
    switch ($payment['type_id']) {
        case '✅':
            $stats = '❌';
            break;
        case '❌':
            $stats = '✅';
            break;
    }
    $zarinPal = $db->query("SELECT * FROM settings WHERE `type` = 'zarinpal'")->fetch_assoc();
    $nextPay = $db->query("SELECT * FROM settings WHERE `type` = 'nexpay'")->fetch_assoc();
    $idPay = $db->query("SELECT * FROM settings WHERE `type` = 'idpay'")->fetch_assoc();
    $zibal = $db->query("SELECT * FROM settings WHERE `type` = 'zibal'")->fetch_assoc();
    $currency = $db->query("SELECT * FROM settings WHERE `type` = 'currency'")->fetch_assoc();
    $payOffline = $db->query("SELECT * FROM settings WHERE `type` = 'payOffline'")->fetch_assoc();

    switch ($explode[1]) {
        case "zarinpal":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $stats, 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $nextPay['type_id'], 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $idPay['type_id'], 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $zibal['type_id'], 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;
        case "nexpay":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $zarinPal['type_id'], 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $stats, 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $idPay['type_id'], 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $zibal['type_id'], 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;
        case "idpay":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $zarinPal['type_id'], 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $nextPay['type_id'], 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $stats, 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $zibal['type_id'], 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;
        case "zibal":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $zarinPal['type_id'], 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $nextPay['type_id'], 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $idPay['type_id'], 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $stats, 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;

        case "currency":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $zarinPal['type_id'], 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $nextPay['type_id'], 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $idPay['type_id'], 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $zibal['type_id'], 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $stats, 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $payOffline['type_id'], 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;
        case "payOffline":
            $status = json_encode(['inline_keyboard' => [[['text' => "📍 وضعیت نمایش", 'callback_data' => 'n'], ['text' => "🌟 نام درگاه", 'callback_data' => 'n']], [['text' => $zarinPal['type_id'], 'callback_data' => 'status_zarinpal'], ['text' => "زرین پال", 'callback_data' => 'n']], [['text' => $nextPay['type_id'], 'callback_data' => 'status_nexpay'], ['text' => "نکست پی", 'callback_data' => 'n']], [['text' => $idPay['type_id'], 'callback_data' => 'status_idpay'], ['text' => "آیدی پی", 'callback_data' =>  'n']], [['text' => $zibal['type_id'], 'callback_data' => 'status_zibal'], ['text' => "زیبال", 'callback_data' =>  'n']], [['text' => $currency['type_id'], 'callback_data' =>  'status_currency'], ['text' => "درگاه ارز دیجیتال", 'callback_data' =>  'n']], [['text' => $stats, 'callback_data' =>  'status_payOffline'], ['text' => "کارت به کارت", 'callback_data' =>  'n']],]]);
            break;
    }

    $db->query("UPDATE settings SET `type_id` = '$stats' WHERE `type` = '$explode[1]'");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => $status]);
} elseif (strpos($data, 'stats_') !== false) {
    $explode = explode('_', $data);
    $setting = $db->query("SELECT * FROM settings WHERE `type` = '$explode[1]'")->fetch_assoc();
    $stats = '';
    switch ($setting['type_id']) {
        case 'on':
            $stats = 'off';
            break;
        case 'off':
            $stats = 'on';
            break;
    }
    $bot = $db->query("SELECT * FROM settings WHERE `type` = 'bot'")->fetch_assoc();
    $phoneverify = $db->query("SELECT * FROM settings WHERE `type` = 'phoneVerify'")->fetch_assoc();
    $backup = $db->query("SELECT * FROM settings WHERE `type` = 'backup'")->fetch_assoc();
    $backUpDb = $db->query("SELECT * FROM settings WHERE `type` = 'backupDb'")->fetch_assoc();

    switch ($explode[1]) {
        case "bot":
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت", 'callback_data' => 'n'], ['text' => "🌟 نام", 'callback_data' => 'n']],
                [['text' => $stats == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_bot'], ['text' => "وضعیت ربات", 'callback_data' => 'n']],
                [['text' => $phoneverify['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_phoneVerify'], ['text' => "تایید شماره", 'callback_data' => 'n']],
                [['text' => $backup['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backup'], ['text' => "بک‌آپ از پنل x-ui", 'callback_data' =>  'n']],
                [['text' => $backUpDb['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backupDb'], ['text' => "بک‌آپ از دیتابیس ربات", 'callback_data' =>  'n']],
            ]]);
            break;
        case "phoneVerify":
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت", 'callback_data' => 'n'], ['text' => "🌟 نام", 'callback_data' => 'n']],
                [['text' => $bot['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_bot'], ['text' => "وضعیت ربات", 'callback_data' => 'n']],
                [['text' => $stats == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_phoneVerify'], ['text' => "تایید شماره", 'callback_data' => 'n']],
                [['text' => $backup['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backup'], ['text' => "بک‌آپ از پنل x-ui", 'callback_data' =>  'n']],
                [['text' => $backUpDb['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backupDb'], ['text' => "بک‌آپ از دیتابیس ربات", 'callback_data' =>  'n']],
            ]]);
            break;
        case "backup":
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت", 'callback_data' => 'n'], ['text' => "🌟 نام", 'callback_data' => 'n']],
                [['text' => $bot['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_bot'], ['text' => "وضعیت ربات", 'callback_data' => 'n']],
                [['text' => $phoneverify['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_phoneVerify'], ['text' => "تایید شماره", 'callback_data' => 'n']],
                [['text' => $stats == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backup'], ['text' => "بک‌آپ از پنل x-ui", 'callback_data' =>  'n']],
                [['text' => $backUpDb['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backupDb'], ['text' => "بک‌آپ از دیتابیس ربات", 'callback_data' =>  'n']],
            ]]);
            break;
        case "backupDb":
            $status = json_encode(['inline_keyboard' => [
                [['text' => "📍 وضعیت", 'callback_data' => 'n'], ['text' => "🌟 نام", 'callback_data' => 'n']],
                [['text' => $bot['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_bot'], ['text' => "وضعیت ربات", 'callback_data' => 'n']],
                [['text' => $phoneverify['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_phoneVerify'], ['text' => "تایید شماره", 'callback_data' => 'n']],
                [['text' => $backup['type_id'] == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backup'], ['text' => "بک‌آپ از پنل x-ui", 'callback_data' =>  'n']],
                [['text' => $stats == 'on' ? '✅' : '❌', 'callback_data' =>  'stats_backupDb'], ['text' => "بک‌آپ از دیتابیس ربات", 'callback_data' =>  'n']],
            ]]);
            break;
    }

    $db->query("UPDATE settings SET `type_id` = '$stats' WHERE `type` = '$explode[1]'");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => $status]);
}
// =========== Answer user ================== \\
if (strpos($data, 'support|') !== false) {
    $msgId = $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ برای پاسخ به کاربر بر روی همین پیام ریپلای کنید!",])['result']['message_id'];
    $explode = explode('|', $data);
    $db->query("UPDATE user SET step = 'support|{$explode[1]}|{$explode[2]}|$msgId' WHERE id = '$from_id'");
}

if (strpos($step, 'support|') !== false || strpos($step, 'payAnswere|') !== false) {
    $dataMessage = $explode = explode('|', $step);
    if (!isset($data) and $MahdyarEn->ReplyToMessageID() == $dataMessage[3]) {
        switch ($updateType) {
            case "message":
                $MahdyarEn->sendMessage(['chat_id' => $dataMessage[1], 'text' => "$text",  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "photo":
                $MahdyarEn->sendPhoto(['chat_id' => $dataMessage[1], 'photo' => $photo_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "video":
                $MahdyarEn->sendVideo(['chat_id' => $dataMessage[1], 'video' => $video_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "sticker":
                $MahdyarEn->sendSticker(['chat_id' => $dataMessage[1], 'sticker' => $sticker_id,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "voice":
                $MahdyarEn->sendVoice(['chat_id' => $dataMessage[1], 'voice' => $voice_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "document":
                $MahdyarEn->sendDocument(['chat_id' => $dataMessage[1], 'document' => $file_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "audio":
                $MahdyarEn->sendAudio(['chat_id' => $dataMessage[1], 'audio' => $audio_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;

            case "animation":
                $MahdyarEn->sendAnimation(['chat_id' => $dataMessage[1], 'animation' => $gif_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown', 'reply_to_message_id' => $dataMessage[2]]);
                break;
        }
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => " ✋ پیام شما برای کاربر ارسال شد.",]);
    }
}


// Handling data
switch ($data) {
    case "back":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 به منوی اصلی بازگشتید لطفا یکی از دکمه های زیر را انتخاب کنید :", 'reply_markup' => $home]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        exit();
        break;
    case "backAdmin":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 به منوی اصلی بازگشتید لطفا یکی از دکمه های زیر را انتخاب کنید :", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        exit();
        break;

    case "noimnot":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👈 عملیات لغو شد، یکی از گزینه های زیر را انتخاب کنید:", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        exit();
        break;

    case "payShaparak":
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "👈 لطفا مبلغ افزایش موجودی را بین 5,000 الی 1,000,000 تومان وارد کنید:\n\n✅ مراحل پرداخت کاملا ایمن و افزایش موجودی خودکار می باشد\n‌", 'reply_markup' => $backInline]);
        $db->query("UPDATE user SET step = 'payShaparak' WHERE id = '$from_id' ");
        break;

    case "payOffline":
        $payOffline = $db->query("SELECT * FROM settings WHERE `type` = 'payOffline'")->fetch_assoc();
        if ($payOffline['type_id'] == '✅') {
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "👈 لطفا مبلغ افزایش موجودی را بین 5,000 الی 1,000,000 تومان وارد کنید:\n\n✅ پس از پرداخت فیش خود را ارسال کنید تا پرداخت شما تایید شود.\n‌", 'reply_markup' => $backInline]);
            $db->query("UPDATE user SET step = 'payOffline' WHERE id = '$from_id' ");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر امکان کارت به کارت وجود ندارد، لطفا از سایر روش های پرداخت استفاده کنید", 'reply_markup' => $home]);
        }
        break;


    case "payCurrency":
        $currency = $db->query("SELECT * FROM settings WHERE `type` = 'currency'")->fetch_assoc();
        if ($currency['type_id'] == '✅') {
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "👈 لطفا مبلغ افزایش موجودی را بین 5,000 الی 1,000,000 تومان وارد کنید:\n\n✅ مراحل پرداخت با درگاه NOWPayments و افزایش موجودی خودکار می باشد\n‌", 'reply_markup' => $backInline]);
            $db->query("UPDATE user SET step = 'payCurrency' WHERE id = '$from_id' ");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ درحال حاضر امکان پرداخت با درگاه nowPayment وجود ندارد، لطفا از سایر روش های پرداخت استفاده کنید", 'reply_markup' => $home]);
        }
        break;

    case "subset":
        $sernameBot = "@" . Config::USERNAME_BOT;
        $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => new CURLFile("import/banner.jpg"), 'caption' => "📲 پیشرفته ترین ربات #خرید کانفیگ v2ray\n\n🚀 به راحتی کانفیگ خود را تهیه کنید و از اینترنت بدون محدودیت لذت ببرید\n🌐 پشتیبانی از انواع اپراتور های اینترنت\n🌍 امکان دریافت کانفیگ از 10 لوکیشن متفاوت\n\n🌟 پرداخت ایمن با درگاه شاپرک و ارز مجازی\n🔥 کاملا خودکار\n\n👇 همین حالا وارد شوید‌\n<a href='https://t.me/" . Config::USERNAME_BOT . "?start=$from_id'>$sernameBot</a>\n‌", 'parse_mode' => 'html', 'reply_markup' => $home]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ شما میتوانید با اشتراک گذاری این بنر به ازای هر فردی که با لینک شما عضو ربات شود {$config->subset} تومان اعتبار رایگان بگیرید 😁\n\n🌟 همچنین اگر یکی از زیرمجموعه های شما پرداختی در ربات انجام دهد، {$config->commission} درصد مبلغ به کیف پول شما اضافه خواهد شد.\n\n📌 شما میتوانید از طریق این اعتبار سرویس های مارا خریداری کنید یا سرویس های خریداری شده را تمدید کنید\n\n⚠️ هشدار: لینک زیر مجوعه گیری شده در بنر بالا بصورت اینلاین می باشد از تغییر متن خود داری کنید یا از لینک زیر استفاده کنید 👇\n\n🔗 https://t.me/" . Config::USERNAME_BOT . "?start=$from_id", 'reply_markup' => $home, 'reply_to_message_id' => $message_id + 1]);
        break;

    case "addCh+":
        $random = $MahdyarEn->random();
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $db->query("UPDATE user SET step = '/lock_$random' WHERE id = '$from_id'");
        $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "برای افزودن قفل(کانال یا گروه) طبق مراحل زیر پیش بروید👇\n\n1️⃣ ربات را در (کانال یا گروه) مورد نظر ادمین کنید.\n2️⃣ دستور زیر را کپی و در (کانال یا گروه) ارسال کنید.\n<code>/lock_$random</code>\n☑️ اگر پیام شما حذف شد به معنای اضافه شدن کانال شما است.", 'parse_mode' => 'html', 'reply_markup' =>  $back]);
        break;

    case "cancelSending":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ صف ارسال پیام با موفقیت خالی شد اکنون میتوانید پیام خود را دوباره بفرستید", 'reply_markup' => $admin]);
        $db->query("UPDATE sendall SET step = '' , `text` = '' , user = '0' , `block` = '0' , chat = '', `type` = '', MsgId = '' , ChatID = ''");
        $db->query("UPDATE user SET step = '' WHERE id = '$from_id'");
        exit();
        break;

    case "myServices":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $userConfigs = $db->query("SELECT * FROM config WHERE user = '$chat_id'")->fetch_assoc();
        if ($userConfigs) {
            $userConfig = $db->query("SELECT * FROM config WHERE user = '$chat_id' LIMIT 10 OFFSET 0");
            while ($row = $userConfig->fetch_assoc()) {
                @$selectServer = $db->query("SELECT servers.name FROM servers JOIN plan ON plan.serverid = servers.id WHERE plan.id = '{$row['planid']}' ")->fetch_assoc();
                $button[] = [['text' => $selectServer["name"] . " - " . $row['code'], 'callback_data' => "manageService_{$row['code']}"]];
            }
            $configCount = $db->query("SELECT id FROM config WHERE user = '$chat_id'")->num_rows;
            if ((checkPage(1, $configCount - 1, 10) != 1)) {
                $button[] = [['text' => "👉", 'callback_data' => "servicePage_2"]];
            }
            $button[] = [['text' => "🔙 بازگشت", 'callback_data' => 'back']];
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👇 جهت مدیریت، یکی از سرویس های خود را  انتخاب کنید", 'reply_markup' => json_encode(['inline_keyboard' => $button]), 'parse_mode' => 'html']);
            $db->query("UPDATE user SET step = 'seeServices' WHERE id = '$from_id' ");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لیست سفارش ها شما خالی می باشد. لطفا یک پلن جدید خریداری کنید.", 'reply_markup' => $home]);
        }
        break;
}


// Buttons ... 
require_once 'import/button.php';
require_once 'import/division.php';
$db->close();
