<?php
error_reporting(0);
date_default_timezone_set("asia/tehran");

require_once '../class/Config.php';
require_once '../class/Base.php';
require_once  '../api/XuiApi.php';

$MahdyarEn = new Base(Config::API_KEY);
$config = new Config();

// database Variable
$db = $config->db();
$allConfigs = $db->query("SELECT plan.name,config.* FROM config JOIN plan ON config.planid = plan.id")->num_rows;
$expireCount = $db->query("SELECT * FROM settings WHERE `type` = 'expire'")->fetch_assoc()['type_id'];

// functions
function getSize($size, $round = 2)
{
    if ($size == 0) return "0 بایت";
    return round($size / pow(1024, ($i = floor(log($size, 1024)))), $round) . ' ' . ['بایت', 'کیلوبایت', 'مگابایت', 'گیگابایت', 'ترابایت', 'پتابایت'][$i];
}

function ConnectXui($link, $username, $password)
{
    $isHttps = substr($link, 0, 7) === "http://" ? false : true;
    $url = explode(':', str_replace(array("http://", "https://"), "", $link));
    return new XuiApi($isHttps, $url[0], $url[1], $username, $password);
}

//////////////////// 

// check service expire and notif user

if ($expireCount >= 0) {
    $configs = $db->query("SELECT plan.name,plan.rowid,config.* FROM config JOIN plan ON config.planid = plan.id LIMIT 100 OFFSET $expireCount");
    $dateNow = date('Y/m/d');
    while ($row = $configs->fetch_assoc()) {
        $expireD = strtotime(date('Y/m/d', time())) - strtotime($row['expire']);
        $expireD = $expireD / 86400;
        if ($row['name'] != 'testService') {

            if (time() >= strtotime("{$row['expire']} -1 days") and  $row['say'] == 0) {
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "⚠️ تنها 1 روز به تاریخ تمدید کانفیگ شما با آیدی {$row['id']} و با نام: «{$row['code']}» از پلن {$row['name']} مانده است، لطفا هرچه سریع تر اقدام به تمدید کنید درصورت اتمام مهلت، سرویس شما بصورت خودکار از سرور حذف خواهد شد.\n‌", 'parse_mode' => 'html']);
                $db->query("UPDATE config SET say =say+1 WHERE id = '{$row['id']}'");
            } elseif (time() >= strtotime("{$row['expire']} -5 hours") and $row['say'] == 1) {
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "⚠️ تنها 5 ساعت به تاریخ تمدید کانفیگ شما با آیدی {$row['id']} و با نام: «{$row['code']}» از پلن {$row['name']} مانده است، لطفا هرچه سریع تر اقدام به تمدید کنید درصورت اتمام مهلت، سرویس شما بصورت خودکار از سرور حذف خواهد شد.\n‌", 'parse_mode' => 'html']);
                $db->query("UPDATE config SET say =say+1 WHERE id = '{$row['id']}'");
            } elseif (time() >= strtotime("{$row['expire']}") and  $row['say'] == 2) {
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "❌ کانفیگ شما با آیدی {$row['id']} و با نام: «{$row['code']}» از پلن {$row['name']} به علت عدم تمدید خاموش شد، تا 1 روز مهلت دارید کانفیگ خود را تمدید کنید، در غیر این صورت از  سرور پاک خواهد شد.\n‌", 'parse_mode' => 'html']);
                $db->query("UPDATE config SET say =say+1 WHERE id = '{$row['id']}'");
            } elseif (time() >= strtotime("{$row['expire']} +1 days")) {
                $selectServer = $db->query("SELECT servers.* FROM servers JOIN plan ON servers.id = plan.serverid WHERE plan.id = '{$row['planid']}'")->fetch_assoc();
                $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
                $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
                $xui = new XuiApi($isHttps, $url[0], $url[1], $selectServer['username'], $selectServer['password']);
                $remove = $xui->removeInbound($row['inboundid'], $row['clientid']);
                if ($remove['success']) {
                    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "❌ کانفیگ با آیدی {$row['id']} و با نام: «{$row['code']}» از پلن {$row['name']} متعلق به کاربر <a href='tg://user?id={$row['user']}'>{$row['user']}</a> بطور کامل از سرور حذف شد.\n#حذف\n.", 'parse_mode' => 'html']);
                } else {
                    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⭕️ خطایی هنگام حذف کانفیگ کاربر <a href='tg://user?id={$row['user']}'>{$row['user']}</a> با آیدی {$row['id']} و کد « <code>{$row['remark']}</code> » از پنل xui پیش آمده است.\n\n👈 امکان دارد این کانفیگ قبلا بصورت دستی از پنل حذف شده باشد\n#مشکل_حذف\n.", 'parse_mode' => 'html']);
                }
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "❌ کانفیگ شما با آیدی {$row['id']} و با نام: «{$row['code']}» از پلن {$row['name']} به علت عدم تمدید بصورت کامل از سرور حذف شد.\n‌", 'parse_mode' => 'html']);
                $db->query("DELETE FROM `config` WHERE id = '{$row['id']}'");
            }
        } else {
            if (time() >= strtotime("{$row['expire']} -5 hours") and $row['say'] == 0) {
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "⚠️ تنها 5 ساعت به مهلت استفاده از اکانت تست شما باقی مانده\n‌", 'parse_mode' => 'html']);
                $db->query("UPDATE config SET say =say+1 WHERE id = '{$row['id']}'");
            } elseif (time() >= strtotime("{$row['expire']}") and  $row['say'] == 1) {
                $selectServer = $db->query("SELECT servers.* FROM servers JOIN plan ON servers.id = plan.serverid WHERE plan.id = '{$row['planid']}'")->fetch_assoc();
                $isHttps = substr($selectServer['link'], 0, 7) === "http://" ? false : true;
                $url = explode(':', str_replace(array("http://", "https://"), "", $selectServer['link']));
                $xui = new XuiApi($isHttps, $url[0], $url[1], $selectServer['username'], $selectServer['password']);
                $remove = $xui->removeInbound($row['inboundid'], $row['clientid']);
                if ($remove['success']) {
                    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "❌ اکانت تست متعلق به کاربر <a href='tg://user?id={$row['user']}'>{$row['user']}</a> بطور کامل از سرور حذف شد.\n#حذف\n.", 'parse_mode' => 'html']);
                } else {
                    $MahdyarEn->Sendmessage(['chat_id' => Config::CHANNEL_REPORT, 'text' => "⭕️ خطایی هنگام حذف کانفیگ تستی کاربر <a href='tg://user?id={$row['user']}'>{$row['user']}</a> با آیدی {$row['id']} و کد « <code>{$row['remark']}</code> » از پنل xui پیش آمده است.\n\n👈 امکان دارد این کانفیگ قبلا بصورت دستی از پنل حذف شده باشد\n#مشکل_حذف\n.", 'parse_mode' => 'html']);
                }
                $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "❌ مهلت استفاده از اکانت تستی شما به پایان رسید و کانفیگ بصورت کامل حذف شد\n‌", 'parse_mode' => 'html']);
                $db->query("DELETE FROM `config` WHERE id = '{$row['id']}'");
            }
        }
    }
    $db->query("UPDATE `settings` SET `type_id` = `type_id` + 500 WHERE `type` = 'expire'");
    if ($expireCount + 501 > $allConfigs) {
        echo "yess";
        $db->query("UPDATE `settings` SET `type_id` = 0 WHERE `type` = 'expire'");
    }
}


// check service remain traffic and notif user

$configs = $db->query("SELECT servers.password,servers.username,plan.name,plan.rowid,config.*,servers.link FROM config JOIN plan ON config.planid = plan.id JOIN servers ON plan.serverid = servers.id");
while ($row = $configs->fetch_assoc()) {
    $xui =  ConnectXui($row['link'], $row['username'], $row['password']);
    $result = $xui->list(['id' => (int)$row['inboundid']])[0];
    if ($result['id'] && !$row['alert']) {
        if ($row['rowid'] == 0) {
            $totalTr = $result['total'];
            $upTr =  $result['up'];
            $down =  $result['down'];
        } else {
            $clientStats = $result["clientStats"];
            $cIndex = $xui->getClientStatsIndexByEmail($clientStats, $row['clientid']);
            if (!$cIndex) continue;
            $client = $clientStats[$cIndex];
            $totalTr =  $client['total'];
            $upTr =  $client['up'];
            $down =  $client['down'];
        }
        $REMAIN = $totalTr - $upTr - $down;
        if ($REMAIN <= 0.1 * $totalTr) {
            $REMAIN = getSize($REMAIN);
            $MahdyarEn->Sendmessage(['chat_id' => $row['user'], 'text' => "⚠️  تنها 10 درصد از حجم سرویس شما  ( {$row['code']} )  باقی مانده است ( $REMAIN ).\n‌", 'parse_mode' => 'html', 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "مدیریت سرویس", 'callback_data' => "manageService_{$row['code']}"]]]])]);
            $db->query("UPDATE config SET alert = 1 WHERE id = '{$row['id']}'");
        }
    }
}
