<?php

require_once '../class/Config.php';
require_once '../class/Base.php';
require_once  '../api/XuiApi.php';
// require JDF => jalali Date
require_once  'jdf.php';

$MahdyarEn = new Base(Config::API_KEY);
$config = new Config();
$db = $config->db();
@$time = jdate('H:i:s', strtotime("-1 hours"));
@$date = jdate('l j F Y');
@$backUp = $db->query("SELECT * FROM settings WHERE `type` = 'backup'")->fetch_assoc();
@$backUpDb = $db->query("SELECT * FROM settings WHERE `type` = 'backupDb'")->fetch_assoc();

function convert($byte)
{
    return round($byte / pow(1024, ($i = floor(log($byte, 1024)))), 2) . ' ' . ['', 'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'][$i] . 'B';
}

if ($backUp['type_id'] == 'on') {

    @$selectServer = $db->query("SELECT * FROM servers");
    while ($row = $selectServer->fetch_assoc()) {
        $isHttps = substr($row['link'], 0, 7) === "http://" ? false : true;
        $url = explode(':', str_replace(array("http://", "https://"), "", $row['link']));
        $xui = new XuiApi($isHttps, $url[0], $url[1], $row['username'], $row['password']);

        // Open a file handle to write the file
        @$result = $xui->getDb();
        if ($result) {
            $fh = fopen("x-ui.db", "w");
            fwrite($fh, $result);
            fclose($fh);
            $fileSize = convert(filesize("x-ui.db"));
            $MahdyarEn->sendDocument(['chat_id' => Config::CHANNEL_BACK_UP, 'document' => new CURLFile("x-ui.db"), 'caption' => "📂 <a href='{$row['link']}'>بک‌آپ پنل xui</a>\n\n🔖 نام سرور: {$row['name']}\n💾 حجم بک‌آپ: $fileSize\n🕒 $date | $time\n\n#بک‌آپ\n‌", 'parse_mode' => 'html']);
            @unlink("x-ui.db");
        }
    }
} else {
    echo "X-UI BACKUP is Off </br>";
}

if ($backUpDb['type_id'] == 'on') {

    $db->query("SET NAMES 'utf8'");
    $queryTables    = $db->query('SHOW TABLES');
    while ($row = $queryTables->fetch_row()) {
        $target_tables[] = $row[0];
    }
    foreach ($target_tables as $table) {
        $result         =   $db->query('SELECT * FROM ' . $table);
        $fields_amount  =   $result->field_count;
        $rows_num = $db->affected_rows;
        $res            =   $db->query('SHOW CREATE TABLE ' . $table);
        $TableMLine     =   $res->fetch_row();
        $content        = (!isset($content) ?  '' : $content) . "\n\n" . $TableMLine[1] . ";\n\n";
        for ($i = 0, $st_counter = 0; $i < $fields_amount; $i++, $st_counter = 0) {
            while ($row = $result->fetch_row()) { 
                if ($st_counter % 100 == 0 || $st_counter == 0) {
                    $content .= "\nINSERT INTO " . $table . " VALUES";
                }
                $content .= "\n(";
                for ($j = 0; $j < $fields_amount; $j++) {
                    $row[$j] = str_replace("\n", "\\n", addslashes($row[$j]));
                    if (isset($row[$j])) {
                        $content .= '"' . $row[$j] . '"';
                    } else {
                        $content .= '""';
                    }
                    if ($j < ($fields_amount - 1)) {
                        $content .= ',';
                    }
                }
                $content .= ")";
                if ((($st_counter + 1) % 100 == 0 && $st_counter != 0) || $st_counter + 1 == $rows_num) {
                    $content .= ";";
                } else {
                    $content .= ",";
                }
                $st_counter = $st_counter + 1;
            }
        }
        $content .= "\n\n\n";
    }

    file_put_contents("db.sql", $content);
    $fileSize = convert(filesize("db.sql"));
    $MahdyarEn->sendDocument(['chat_id' => Config::CHANNEL_BACK_UP, 'document' => new CURLFile("db.sql"), 'caption' => "📄 بک‌آپ از دیتابیس ربات\n💾 حجم بک‌آپ: $fileSize\n🕒 $date | $time\n\n#بک‌آپ\n‌", 'parse_mode' => 'html']);
    @unlink("db.sql");
} else {
    echo "DB BACKUP is Off </br>";
}
